/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.IcebergView;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IcebergView", generator="Immutables")
@Immutable
public final class ImmutableIcebergView
extends IcebergView {
    private final String id;
    private final String metadataLocation;
    private final int versionId;
    private final int schemaId;
    private final String sqlText;
    private final String dialect;

    private ImmutableIcebergView(Builder builder) {
        this.metadataLocation = builder.metadataLocation;
        this.versionId = builder.versionId;
        this.schemaId = builder.schemaId;
        this.sqlText = builder.sqlText;
        this.dialect = builder.dialect;
        this.id = builder.id != null ? builder.id : Objects.requireNonNull(super.getId(), "id");
    }

    private ImmutableIcebergView(String id, String metadataLocation, int versionId, int schemaId, String sqlText, String dialect) {
        this.id = id;
        this.metadataLocation = metadataLocation;
        this.versionId = versionId;
        this.schemaId = schemaId;
        this.sqlText = sqlText;
        this.dialect = dialect;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="metadataLocation")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @Override
    @JsonProperty(value="versionId")
    public int getVersionId() {
        return this.versionId;
    }

    @Override
    @JsonProperty(value="schemaId")
    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    @JsonProperty(value="sqlText")
    public String getSqlText() {
        return this.sqlText;
    }

    @Override
    @JsonProperty(value="dialect")
    public String getDialect() {
        return this.dialect;
    }

    public final ImmutableIcebergView withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(newValue, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, this.dialect);
    }

    public final ImmutableIcebergView withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, newValue, this.versionId, this.schemaId, this.sqlText, this.dialect);
    }

    public final ImmutableIcebergView withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, value, this.schemaId, this.sqlText, this.dialect);
    }

    public final ImmutableIcebergView withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, value, this.sqlText, this.dialect);
    }

    public final ImmutableIcebergView withSqlText(String value) {
        String newValue = Objects.requireNonNull(value, "sqlText");
        if (this.sqlText.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, newValue, this.dialect);
    }

    public final ImmutableIcebergView withDialect(String value) {
        String newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergView(this.id, this.metadataLocation, this.versionId, this.schemaId, this.sqlText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergView && this.equalTo(0, (ImmutableIcebergView)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergView another) {
        return this.id.equals(another.id) && this.metadataLocation.equals(another.metadataLocation) && this.versionId == another.versionId && this.schemaId == another.schemaId && this.sqlText.equals(another.sqlText) && this.dialect.equals(another.dialect);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.metadataLocation.hashCode();
        h += (h << 5) + this.versionId;
        h += (h << 5) + this.schemaId;
        h += (h << 5) + this.sqlText.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        return h;
    }

    public String toString() {
        return "IcebergView{id=" + this.id + ", metadataLocation=" + this.metadataLocation + ", versionId=" + this.versionId + ", schemaId=" + this.schemaId + ", sqlText=" + this.sqlText + ", dialect=" + this.dialect + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIcebergView fromJson(Json json) {
        Builder builder = ImmutableIcebergView.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.metadataLocation != null) {
            builder.metadataLocation(json.metadataLocation);
        }
        if (json.versionIdIsSet) {
            builder.versionId(json.versionId);
        }
        if (json.schemaIdIsSet) {
            builder.schemaId(json.schemaId);
        }
        if (json.sqlText != null) {
            builder.sqlText(json.sqlText);
        }
        if (json.dialect != null) {
            builder.dialect(json.dialect);
        }
        return builder.build();
    }

    public static ImmutableIcebergView copyOf(IcebergView instance) {
        if (instance instanceof ImmutableIcebergView) {
            return (ImmutableIcebergView)instance;
        }
        return ImmutableIcebergView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergView", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private static final long INIT_BIT_VERSION_ID = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private static final long INIT_BIT_SQL_TEXT = 8L;
        private static final long INIT_BIT_DIALECT = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String metadataLocation;
        private int versionId;
        private int schemaId;
        @Nullable
        private String sqlText;
        @Nullable
        private String dialect;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IcebergView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Content instance;
            long bits = 0L;
            if (object instanceof IcebergView) {
                instance = (IcebergView)object;
                this.metadataLocation(((IcebergView)instance).getMetadataLocation());
                this.versionId(((IcebergView)instance).getVersionId());
                this.sqlText(((IcebergView)instance).getSqlText());
                this.dialect(((IcebergView)instance).getDialect());
                if ((bits & 1L) == 0L) {
                    this.id(instance.getId());
                    bits |= 1L;
                }
                this.schemaId(((IcebergView)instance).getSchemaId());
            }
            if (object instanceof Content) {
                instance = (Content)object;
                if ((bits & 1L) == 0L) {
                    this.id(instance.getId());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="metadataLocation")
        @CanIgnoreReturnValue
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="versionId")
        @CanIgnoreReturnValue
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="schemaId")
        @CanIgnoreReturnValue
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="sqlText")
        @CanIgnoreReturnValue
        public final Builder sqlText(String sqlText) {
            this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="dialect")
        @CanIgnoreReturnValue
        public final Builder dialect(String dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableIcebergView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIcebergView(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("versionId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sqlText");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("dialect");
            }
            return "Cannot build IcebergView, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IcebergView", generator="Immutables")
    static final class Json
    extends IcebergView {
        @Nullable
        String id;
        @Nullable
        String metadataLocation;
        int versionId;
        boolean versionIdIsSet;
        int schemaId;
        boolean schemaIdIsSet;
        @Nullable
        String sqlText;
        @Nullable
        String dialect;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="metadataLocation")
        public void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @JsonProperty(value="versionId")
        public void setVersionId(int versionId) {
            this.versionId = versionId;
            this.versionIdIsSet = true;
        }

        @JsonProperty(value="schemaId")
        public void setSchemaId(int schemaId) {
            this.schemaId = schemaId;
            this.schemaIdIsSet = true;
        }

        @JsonProperty(value="sqlText")
        public void setSqlText(String sqlText) {
            this.sqlText = sqlText;
        }

        @JsonProperty(value="dialect")
        public void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetadataLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSchemaId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSqlText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDialect() {
            throw new UnsupportedOperationException();
        }
    }
}

