/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableMerge;
import org.projectnessie.model.Validation;

@Schema(type=SchemaType.OBJECT, title="Merge Operation", properties={@SchemaProperty(name="fromRefName", pattern="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$"), @SchemaProperty(name="fromHash", pattern="^[0-9a-fA-F]{8,64}$")})
@JsonSerialize(as=ImmutableMerge.class)
@JsonDeserialize(as=ImmutableMerge.class)
@Value.Immutable
public interface Merge {
    @NotBlank
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    public @NotBlank @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String getFromHash();

    @NotBlank
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    public @NotBlank @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String getFromRefName();

    @Value.Check
    default public void checkHash() {
        String hash = this.getFromHash();
        if (hash != null) {
            Validation.validateHash(hash);
        }
    }
}

