package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code EntriesParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.EntriesParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.EntriesParams}.
 * <p><em>{@code EntriesParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.EntriesParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class EntriesParamsBuilder {
  private @Nullable String hashOnRef;
  private @Nullable Integer maxRecords;
  private @Nullable String pageToken;
  private @Nullable Integer namespaceDepth;
  private @Nullable String filter;

  /**
   * Creates a {@code EntriesParamsBuilder} factory builder.
   * <pre>
   * new EntriesParamsBuilder()
   *    .hashOnRef(String | null) // nullable {@code hashOnRef}
   *    .maxRecords(Integer | null) // nullable {@code maxRecords}
   *    .pageToken(String | null) // nullable {@code pageToken}
   *    .namespaceDepth(Integer | null) // nullable {@code namespaceDepth}
   *    .filter(String | null) // nullable {@code filter}
   *    .build();
   * </pre>
   */
  public EntriesParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code hashOnRef} attribute.
   * @param hashOnRef The value for hashOnRef (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final EntriesParamsBuilder hashOnRef(@Nullable String hashOnRef) {
    this.hashOnRef = hashOnRef;
    return this;
  }

  /**
   * Initializes the value for the {@code maxRecords} attribute.
   * @param maxRecords The value for maxRecords (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final EntriesParamsBuilder maxRecords(@Nullable Integer maxRecords) {
    this.maxRecords = maxRecords;
    return this;
  }

  /**
   * Initializes the value for the {@code pageToken} attribute.
   * @param pageToken The value for pageToken (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final EntriesParamsBuilder pageToken(@Nullable String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Initializes the value for the {@code namespaceDepth} attribute.
   * @param namespaceDepth The value for namespaceDepth (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final EntriesParamsBuilder namespaceDepth(@Nullable Integer namespaceDepth) {
    this.namespaceDepth = namespaceDepth;
    return this;
  }

  /**
   * Initializes the value for the {@code filter} attribute.
   * @param filter The value for filter (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final EntriesParamsBuilder filter(@Nullable String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.EntriesParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.EntriesParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public EntriesParams build() {
    return new EntriesParams(hashOnRef, maxRecords, pageToken, namespaceDepth, filter);
  }
}
