package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Namespace;

/**
 * {@code MultipleNamespacesParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.MultipleNamespacesParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.MultipleNamespacesParams}.
 * <p><em>{@code MultipleNamespacesParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.MultipleNamespacesParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class MultipleNamespacesParamsBuilder {
  private static final long INIT_BIT_REF_NAME = 0x1L;
  private long initBits = 0x1L;

  private @Nullable String refName;
  private @Nullable Namespace namespace;
  private @Nullable String hashOnRef;

  /**
   * Creates a {@code MultipleNamespacesParamsBuilder} factory builder.
   * <pre>
   * new MultipleNamespacesParamsBuilder()
   *    .refName(String) // required {@code refName}
   *    .namespace(org.projectnessie.model.Namespace | null) // nullable {@code namespace}
   *    .hashOnRef(String | null) // nullable {@code hashOnRef}
   *    .build();
   * </pre>
   */
  public MultipleNamespacesParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code refName} attribute.
   * @param refName The value for refName 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MultipleNamespacesParamsBuilder refName(String refName) {
    this.refName = Objects.requireNonNull(refName, "refName");
    initBits &= ~INIT_BIT_REF_NAME;
    return this;
  }

  /**
   * Initializes the value for the {@code namespace} attribute.
   * @param namespace The value for namespace (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MultipleNamespacesParamsBuilder namespace(@Nullable Namespace namespace) {
    this.namespace = namespace;
    return this;
  }

  /**
   * Initializes the value for the {@code hashOnRef} attribute.
   * @param hashOnRef The value for hashOnRef (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final MultipleNamespacesParamsBuilder hashOnRef(@Nullable String hashOnRef) {
    this.hashOnRef = hashOnRef;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.MultipleNamespacesParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.MultipleNamespacesParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public MultipleNamespacesParams build() {
    checkRequiredAttributes();
    return new MultipleNamespacesParams(refName, namespace, hashOnRef);
  }

  private boolean refNameIsSet() {
    return (initBits & INIT_BIT_REF_NAME) == 0;
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!refNameIsSet()) attributes.add("refName");
    return "Cannot build MultipleNamespacesParams, some of required attributes are not set " + attributes;
  }
}
