package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Namespace;

/**
 * {@code NamespaceParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.NamespaceParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.NamespaceParams}.
 * <p><em>{@code NamespaceParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.NamespaceParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class NamespaceParamsBuilder {
  private static final long INIT_BIT_REF_NAME = 0x1L;
  private static final long INIT_BIT_NAMESPACE = 0x2L;
  private long initBits = 0x3L;

  private @Nullable String refName;
  private @Nullable Namespace namespace;
  private @Nullable String hashOnRef;

  /**
   * Creates a {@code NamespaceParamsBuilder} factory builder.
   * <pre>
   * new NamespaceParamsBuilder()
   *    .refName(String) // required {@code refName}
   *    .namespace(org.projectnessie.model.Namespace) // required {@code namespace}
   *    .hashOnRef(String | null) // nullable {@code hashOnRef}
   *    .build();
   * </pre>
   */
  public NamespaceParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code refName} attribute.
   * @param refName The value for refName 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final NamespaceParamsBuilder refName(String refName) {
    this.refName = Objects.requireNonNull(refName, "refName");
    initBits &= ~INIT_BIT_REF_NAME;
    return this;
  }

  /**
   * Initializes the value for the {@code namespace} attribute.
   * @param namespace The value for namespace 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final NamespaceParamsBuilder namespace(Namespace namespace) {
    this.namespace = Objects.requireNonNull(namespace, "namespace");
    initBits &= ~INIT_BIT_NAMESPACE;
    return this;
  }

  /**
   * Initializes the value for the {@code hashOnRef} attribute.
   * @param hashOnRef The value for hashOnRef (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final NamespaceParamsBuilder hashOnRef(@Nullable String hashOnRef) {
    this.hashOnRef = hashOnRef;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.NamespaceParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.NamespaceParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public NamespaceParams build() {
    checkRequiredAttributes();
    return new NamespaceParams(refName, namespace, hashOnRef);
  }

  private boolean refNameIsSet() {
    return (initBits & INIT_BIT_REF_NAME) == 0;
  }

  private boolean namespaceIsSet() {
    return (initBits & INIT_BIT_NAMESPACE) == 0;
  }

  private void checkRequiredAttributes() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!refNameIsSet()) attributes.add("refName");
    if (!namespaceIsSet()) attributes.add("namespace");
    return "Cannot build NamespaceParams, some of required attributes are not set " + attributes;
  }
}
