package org.projectnessie.api.params;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ReferencesParamsBuilder} collects parameters and invokes the static factory method:
 * {@code new org.projectnessie.api.params.ReferencesParams(..)}.
 * Call the {@link #build()} method to get a result of type {@code org.projectnessie.api.params.ReferencesParams}.
 * <p><em>{@code ReferencesParamsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "org.projectnessie.api.params.ReferencesParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class ReferencesParamsBuilder {
  private @Nullable Integer maxRecords;
  private @Nullable String pageToken;
  private @Nullable FetchOption fetchOption;
  private @Nullable String filter;

  /**
   * Creates a {@code ReferencesParamsBuilder} factory builder.
   * <pre>
   * new ReferencesParamsBuilder()
   *    .maxRecords(Integer | null) // nullable {@code maxRecords}
   *    .pageToken(String | null) // nullable {@code pageToken}
   *    .fetchOption(org.projectnessie.api.params.FetchOption | null) // nullable {@code fetchOption}
   *    .filter(String | null) // nullable {@code filter}
   *    .build();
   * </pre>
   */
  public ReferencesParamsBuilder() {
  }

  /**
   * Initializes the value for the {@code maxRecords} attribute.
   * @param maxRecords The value for maxRecords (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ReferencesParamsBuilder maxRecords(@Nullable Integer maxRecords) {
    this.maxRecords = maxRecords;
    return this;
  }

  /**
   * Initializes the value for the {@code pageToken} attribute.
   * @param pageToken The value for pageToken (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ReferencesParamsBuilder pageToken(@Nullable String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Initializes the value for the {@code fetchOption} attribute.
   * @param fetchOption The value for fetchOption (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ReferencesParamsBuilder fetchOption(@Nullable FetchOption fetchOption) {
    this.fetchOption = fetchOption;
    return this;
  }

  /**
   * Initializes the value for the {@code filter} attribute.
   * @param filter The value for filter (can be {@code null})
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final ReferencesParamsBuilder filter(@Nullable String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Invokes {@code new org.projectnessie.api.params.ReferencesParams(..)} using the collected parameters and returns the result of the invocation
   * @return A result of type {@code org.projectnessie.api.params.ReferencesParams}
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public ReferencesParams build() {
    return new ReferencesParams(maxRecords, pageToken, fetchOption, filter);
  }
}
