/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.MultipleNamespacesParams;
import org.projectnessie.model.Namespace;

public class MultipleNamespacesParamsTest {
    @Test
    public void testBuilder() {
        MultipleNamespacesParams params = MultipleNamespacesParams.builder().refName("xx").build();
        Assertions.assertThat((String)params.getRefName()).isEqualTo("xx");
        Assertions.assertThat((Object)params.getNamespace()).isNull();
        Assertions.assertThat((String)params.getHashOnRef()).isNull();
    }

    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MultipleNamespacesParams.builder().build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build MultipleNamespacesParams, some of required attributes are not set [refName]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MultipleNamespacesParams.builder().namespace(Namespace.of((String[])new String[]{"x"})).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build MultipleNamespacesParams, some of required attributes are not set [refName]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MultipleNamespacesParams.builder().hashOnRef("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build MultipleNamespacesParams, some of required attributes are not set [refName]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MultipleNamespacesParams.builder().refName(null).build()).isInstanceOf(NullPointerException.class)).hasMessage("refName");
    }
}

