/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.NamespaceParams;
import org.projectnessie.model.Namespace;

public class NamespaceParamsTest {
    @Test
    public void testBuilder() {
        Namespace namespace = Namespace.parse((String)"a.b.c");
        NamespaceParams params = NamespaceParams.builder().refName("xx").namespace(namespace).build();
        Assertions.assertThat((String)params.getRefName()).isEqualTo("xx");
        Assertions.assertThat((Object)params.getNamespace()).isEqualTo((Object)namespace);
        Assertions.assertThat((String)params.getHashOnRef()).isNull();
    }

    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build NamespaceParams, some of required attributes are not set [refName, namespace]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().refName("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build NamespaceParams, some of required attributes are not set [namespace]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().namespace(Namespace.of((String[])new String[]{"x"})).build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build NamespaceParams, some of required attributes are not set [refName]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().hashOnRef("x").build()).isInstanceOf(IllegalStateException.class)).hasMessage("Cannot build NamespaceParams, some of required attributes are not set [refName, namespace]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().refName(null).build()).isInstanceOf(NullPointerException.class)).hasMessage("refName");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NamespaceParams.builder().namespace(null).build()).isInstanceOf(NullPointerException.class)).hasMessage("namespace");
    }
}

