/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.projectnessie.api.params.AbstractParams;
import org.projectnessie.api.params.RefLogParams;

@Execution(value=ExecutionMode.CONCURRENT)
public class RefLogParamsTest {
    @Test
    public void testBuilder() {
        Integer maxRecords = 23;
        String startHash = "1234567890123456";
        String endHash = "00000";
        String pageToken = "aabbcc";
        String filter = "some_expression";
        Supplier<RefLogParams> generator = () -> RefLogParams.builder().filter(filter).maxRecords(maxRecords).pageToken(pageToken).startHash(startHash).endHash(endHash).build();
        this.verify(maxRecords, startHash, endHash, pageToken, filter, generator);
    }

    @Test
    public void testEmpty() {
        this.verify(null, null, null, null, null, RefLogParams::empty);
    }

    private void verify(Integer maxRecords, String startHash, String endHash, String pageToken, String filter, Supplier<RefLogParams> generator) {
        ((ObjectAssert)Assertions.assertThat((Object)generator.get()).isEqualTo((Object)generator.get())).extracting(new Function[]{AbstractParams::pageToken, AbstractParams::maxRecords, RefLogParams::filter, RefLogParams::startHash, RefLogParams::endHash, RefLogParams::hashCode}).containsExactly(new Object[]{pageToken, maxRecords, filter, startHash, endHash, generator.get().hashCode()});
    }
}

