/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.UriUtil;

@Execution(value=ExecutionMode.CONCURRENT)
public class TestNamespace {
    @Test
    public void testNullAndEmpty() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((List)null)).isInstanceOf(NullPointerException.class)).hasMessage("elements must be non-null");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse(null)).isInstanceOf(NullPointerException.class)).hasMessage("identifier must be non-null");
        Assertions.assertThat((String)Namespace.of((String[])new String[0]).name()).isEmpty();
        Assertions.assertThat((String)Namespace.parse((String)"").name()).isEmpty();
        Assertions.assertThat((Object)Namespace.of((String[])new String[]{""})).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"", true});
        Assertions.assertThat((Object)Namespace.of((String[])new String[]{""})).isEqualTo((Object)Namespace.EMPTY);
        Assertions.assertThat((Object)Namespace.of(Collections.emptyList())).isEqualTo((Object)Namespace.EMPTY);
        Assertions.assertThat((Object)Namespace.of(Collections.singletonList(""))).isEqualTo((Object)Namespace.EMPTY);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"", "something"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[, something]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"", "something", "x"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[, something, x]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"something", "", "x"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[something, , x]' must not contain an empty element.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{"something", "x", ""})).isInstanceOf(IllegalArgumentException.class)).hasMessage("Namespace '[something, x, ]' must not contain an empty element.");
    }

    @Test
    public void testOneElement() {
        Namespace namespace = Namespace.of((String[])new String[]{"foo"});
        Assertions.assertThat((Object)namespace).extracting(new Function[]{Namespace::name, Namespace::isEmpty}).containsExactly(new Object[]{"foo", false});
    }

    @Test
    public void testRoundTrip() {
        List<String> elements = Arrays.asList("a", "b.c", "namespace");
        String pathString = UriUtil.toPathString(elements);
        String expectedPathString = "a.b\u001dc.namespace";
        Assertions.assertThat((String)pathString).isEqualTo(expectedPathString);
        Namespace namespace = Namespace.parse((String)pathString);
        Assertions.assertThat((String)namespace.name()).isEqualTo(pathString);
        Assertions.assertThat((List)namespace.getElements()).isEqualTo(elements);
        Assertions.assertThat((String)namespace.toString()).isEqualTo(pathString);
        Assertions.assertThat((String)namespace.toPathString()).isEqualTo(pathString);
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u001d");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u001dc");
        Assertions.assertThat((String)namespace.name()).startsWith((CharSequence)"a.b\u001dc.namespa");
        Assertions.assertThat((String)namespace.name()).doesNotStartWith((CharSequence)"a.b.c");
        Assertions.assertThat((String)Namespace.parse((String)"a.b.c").name()).doesNotStartWith((CharSequence)"a.b\u001d");
    }

    @Test
    public void testIsSameOrSubElementOf() {
        Namespace namespace = Namespace.of(Arrays.asList("a", "b.c", "namespace"));
        Assertions.assertThatThrownBy(() -> Namespace.EMPTY.isSameOrSubElementOf(null)).hasMessage("namespace must be non-null");
        Assertions.assertThat((boolean)Namespace.EMPTY.isSameOrSubElementOf(Namespace.EMPTY)).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.EMPTY)).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.of((String[])new String[]{"a"}))).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.parse((String)"a"))).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.of((String[])new String[]{"a", "b"}))).isFalse();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.parse((String)"a.b\u001dc"))).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.parse((String)"a.b\u001dc.namespa"))).isFalse();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.parse((String)"a.b\u001dc.namespace"))).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.parse((String)"a.b\u0000c.namespace"))).isTrue();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.of((String[])new String[]{"a", "\u0012b"}))).isFalse();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.of((String[])new String[]{"x"}))).isFalse();
        Assertions.assertThat((boolean)namespace.isSameOrSubElementOf(Namespace.of((String[])new String[]{"a", "b", "c"}))).isFalse();
        Assertions.assertThat((boolean)Namespace.parse((String)"a.b.c").isSameOrSubElementOf(Namespace.parse((String)"a.b\u001dc"))).isFalse();
        Assertions.assertThat((boolean)Namespace.EMPTY.isSameOrSubElementOf(Namespace.of((String[])new String[]{"a"}))).isFalse();
    }

    @Test
    public void testDifferentZeroByteRepresentations() {
        Assertions.assertThat((Object)Namespace.parse((String)"a.b\u001dc.d")).isEqualTo((Object)Namespace.parse((String)"a.b\u0000c.d"));
        Assertions.assertThat((boolean)Namespace.parse((String)"a.b\u001dc.d").isSameOrSubElementOf(Namespace.parse((String)"a.b\u0000c.d"))).isTrue();
        Assertions.assertThat((boolean)Namespace.parse((String)"a.b\u001dc.d").isSameOrSubElementOf(Namespace.parse((String)"a.b\u0000c"))).isTrue();
        Assertions.assertThat((boolean)Namespace.parse((String)"a.b\u0000c.d").isSameOrSubElementOf(Namespace.parse((String)"a.b\u001dc"))).isTrue();
        Assertions.assertThat((String)Namespace.of(Arrays.asList("a", "b.c", "namespace")).name()).doesNotStartWith((CharSequence)"a.b\u0000c");
    }

    @Test
    public void testNamespaceWithProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("location", "/tmp");
        properties.put("x", "y");
        Namespace namespace = Namespace.of(properties, (String[])new String[]{"a", "b.c", "d"});
        Assertions.assertThat((Map)namespace.getProperties()).isEqualTo(properties);
    }

    @ParameterizedTest
    @MethodSource(value={"elementsProvider"})
    void testNamespaceFromElements(String[] elements, String expectedNamespace) {
        Namespace namespace = Namespace.of((String[])elements);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
        Assertions.assertThat((List)namespace.getElements()).containsExactly((Object[])elements);
        namespace = Namespace.of(Arrays.asList(elements));
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
        Assertions.assertThat((List)namespace.getElements()).isEqualTo(Arrays.asList(elements));
    }

    @ParameterizedTest
    @MethodSource(value={"identifierProvider"})
    void testNamespaceParsing(String identifier, String expectedNamespace) {
        Namespace namespace = Namespace.parse((String)identifier);
        Assertions.assertThat((String)namespace.name()).isEqualTo(expectedNamespace);
        Assertions.assertThat((boolean)namespace.isEmpty()).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"invalidElementsProvider"})
    void testInvalidElements(String[] elements) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])elements)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of(Arrays.asList(elements))).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", Arrays.toString(elements)));
    }

    @ParameterizedTest
    @ValueSource(strings={".", "a.", "a.b.c."})
    void testInvalidParsing(String identifier) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.parse((String)identifier)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("'%s' is not a valid namespace identifier (should not end with '.')", identifier));
    }

    @ParameterizedTest
    @ValueSource(strings={"\u0000", "a.\u0000", "a.b.c.\u0000", "\u001d", "a.\u001d", "a.b.c.\u001d"})
    void testZeroByteUsage(String identifier) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])new String[]{identifier})).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Namespace '%s' must not contain a zero byte (\\u0000) / group separator (\\u001D).", Collections.singletonList(identifier)));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidElementsWithNullsProvider"})
    void testNullsInElements(String[] elements) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Namespace.of((String[])elements)).isInstanceOf(IllegalArgumentException.class)).hasMessage(String.format("Namespace '%s' must not contain a null element.", Arrays.toString(elements)));
    }

    private static Stream<Arguments> elementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"a", "b"}, "a.b"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c"}, "a.b.c"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b.c", "d"}, "a.b\u001dc.d"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b_c", "d.e"}, "a.b_c.d\u001de"}), Arguments.of((Object[])new Object[]{new String[]{"a.c", "b.d"}, "a\u001dc.b\u001dd"}));
    }

    private static Stream<Arguments> identifierProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"a", "a"}), Arguments.of((Object[])new Object[]{"a.b", "a.b"}), Arguments.of((Object[])new Object[]{"a.b.c", "a.b.c"}));
    }

    private static Stream<Arguments> invalidElementsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{"."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "."}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c", "."}, "x"}));
    }

    private static Stream<Arguments> invalidElementsWithNullsProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{new String[]{null}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", ".", null}, "x"}), Arguments.of((Object[])new Object[]{new String[]{"a", "b", "c", ".", null}, "x"}));
    }

    @ParameterizedTest
    @MethodSource(value={"namespaceOfAndParseCases"})
    void namespaceOfAndParse(NamespaceOfParse testCase) {
        Assertions.assertThat((Object)testCase.namespace).extracting(new Function[]{Namespace::getElements, Namespace::name, Namespace::toString, Namespace::toPathString}).containsExactly(new Object[]{testCase.elements, testCase.name, testCase.name, testCase.name});
    }

    static List<NamespaceOfParse> namespaceOfAndParseCases() {
        return Arrays.asList(new NamespaceOfParse(Namespace.fromPathString((String)UriUtil.toPathString(Arrays.asList("a", "b.c", "namespace"))), Arrays.asList("a", "b.c", "namespace"), UriUtil.toPathString(Arrays.asList("a", "b.c", "namespace"))), new NamespaceOfParse(Namespace.fromPathString((String)UriUtil.toPathString(Arrays.asList("a", "b.c", "d.e.f.namespace"))), Arrays.asList("a", "b.c", "d.e.f.namespace"), UriUtil.toPathString(Arrays.asList("a", "b.c", "d.e.f.namespace"))), new NamespaceOfParse(Namespace.fromPathString((String)"a.namespace"), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.of((String[])new String[]{"a", "namespace"}), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.of(Arrays.asList("a", "namespace")), Arrays.asList("a", "namespace"), "a.namespace"), new NamespaceOfParse(Namespace.fromPathString((String)"a.b.namespace"), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.of((String[])new String[]{"a", "b", "namespace"}), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.of(Arrays.asList("a", "b", "namespace")), Arrays.asList("a", "b", "namespace"), "a.b.namespace"), new NamespaceOfParse(Namespace.EMPTY, Collections.emptyList(), ""), new NamespaceOfParse(Namespace.of(Collections.singletonList("namespace")), Collections.singletonList("namespace"), "namespace"), new NamespaceOfParse(Namespace.fromPathString((String)"namespace"), Collections.singletonList("namespace"), "namespace"));
    }

    static class NamespaceOfParse {
        final Namespace namespace;
        final List<String> elements;
        final String name;

        NamespaceOfParse(Namespace namespace, List<String> elements, String name) {
            this.namespace = namespace;
            this.elements = elements;
            this.name = name;
        }

        public String toString() {
            return new StringJoiner(", ", NamespaceOfParse.class.getSimpleName() + "[", "]").add("namespace=" + this.namespace).add("elements=" + this.elements).add("name='" + this.name + "'").toString();
        }
    }
}

