/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.projectnessie.model.CommitMeta;

@Execution(value=ExecutionMode.CONCURRENT)
class TestCommitMetaSerde {
    TestCommitMetaSerde() {
    }

    @Test
    void testInstantSerde() throws IOException {
        Instant expectedTime = Instant.ofEpochMilli(423902715000L);
        StringWriter jsonWriter = new StringWriter();
        ObjectMapper mapper = new ObjectMapper();
        JsonGenerator jsonGenerator = new JsonFactory().createGenerator((Writer)jsonWriter);
        SerializerProvider serializerProvider = mapper.getSerializerProvider();
        CommitMeta.InstantSerializer ser = new CommitMeta.InstantSerializer();
        CommitMeta.InstantDeserializer de = new CommitMeta.InstantDeserializer();
        ser.serialize(expectedTime, jsonGenerator, serializerProvider);
        jsonGenerator.flush();
        String result = ((Object)jsonWriter).toString();
        Assertions.assertEquals((Object)"\"1983-06-08T06:45:15Z\"", (Object)result);
        ByteArrayInputStream stream = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
        JsonParser parser = mapper.getFactory().createParser((InputStream)stream);
        DeserializationContext ctxt = mapper.getDeserializationContext();
        parser.nextToken();
        Instant actualTime = de.deserialize(parser, ctxt);
        Assertions.assertEquals((Object)expectedTime, (Object)actualTime);
    }
}

