/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.IcebergTable;

public class TestIcebergTable {
    @ParameterizedTest
    @MethodSource(value={"validMetadata"})
    public void validMetadata(ObjectNode metadata, long snapshotId, int schemaId, int sortOrderId, int specId) {
        IcebergTable view = IcebergTable.of((JsonNode)metadata, (String)"metadataLocation", (String)"id");
        Assertions.assertThat((Object)view).extracting(new Function[]{IcebergTable::getMetadataLocation, Content::getId, IcebergTable::getSnapshotId, IcebergTable::getSchemaId, IcebergTable::getSortOrderId, IcebergTable::getSpecId, IcebergTable::getMetadata}).containsExactly(new Object[]{"metadataLocation", "id", snapshotId, schemaId, sortOrderId, specId, GenericMetadata.of((String)"iceberg", (JsonNode)metadata)});
    }

    static Stream<Arguments> validMetadata() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{TestIcebergTable.metadata(), -1L, 0, 0, 0}), Arguments.arguments((Object[])new Object[]{TestIcebergTable.metadata().put("current-schema-id", 66).put("default-sort-order-id", 123).put("default-spec-id", 345), -1L, 66, 123, 345}), Arguments.arguments((Object[])new Object[]{TestIcebergTable.metadata().put("current-snapshot-id", 42L).put("default-sort-order-id", 123).put("default-spec-id", 345), 42L, 0, 123, 345}), Arguments.arguments((Object[])new Object[]{TestIcebergTable.metadata().put("current-snapshot-id", 42L).put("current-schema-id", 66).put("default-spec-id", 345), 42L, 66, 0, 345}), Arguments.arguments((Object[])new Object[]{TestIcebergTable.metadata().put("current-snapshot-id", 42L).put("current-schema-id", 66).put("default-sort-order-id", 123), 42L, 66, 123, 0}));
    }

    private static ObjectNode metadata() {
        return JsonNodeFactory.instance.objectNode();
    }
}

