/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.IcebergView;

public class TestIcebergView {
    @ParameterizedTest
    @MethodSource(value={"nonExistingFields"})
    public void nonExistingFields(JsonNode metadata) {
        Assertions.assertThatThrownBy(() -> IcebergView.of((JsonNode)metadata, (String)"metadataLocation", (String)"id")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void validMetadata() {
        ObjectNode metadata = TestIcebergView.versions(42, (ArrayNode array) -> {
            ObjectNode version = array.addObject().put("version-id", 42);
            ObjectNode viewDefinition = version.putObject("view-definition");
            viewDefinition.put("sql", "SELECT bar FROM baz");
            ObjectNode schema = viewDefinition.putObject("schema");
            schema.put("schema-id", 66);
        });
        IcebergView view = IcebergView.of((JsonNode)metadata, (String)"metadataLocation", (String)"id");
        Assertions.assertThat((Object)view).extracting(new Function[]{IcebergView::getMetadataLocation, Content::getId, IcebergView::getVersionId, IcebergView::getSchemaId, IcebergView::getDialect, IcebergView::getSqlText, IcebergView::getMetadata}).containsExactly(new Object[]{"metadataLocation", "id", 42, 66, "", "SELECT bar FROM baz", GenericMetadata.of((String)"iceberg", (JsonNode)metadata)});
    }

    static Stream<JsonNode> nonExistingFields() {
        return Stream.of(TestIcebergView.metadata(), TestIcebergView.versions(-1, ArrayNode::addObject), TestIcebergView.versions(42, (ArrayNode array) -> array.addObject().put("version-id", 42)), TestIcebergView.versions(42, (ArrayNode array) -> {
            ObjectNode version = array.addObject().put("version-id", 42);
            version.putObject("view-definition");
        }), TestIcebergView.versions(42, (ArrayNode array) -> {
            ObjectNode version = array.addObject().put("version-id", 42);
            ObjectNode viewDefinition = version.putObject("view-definition");
            viewDefinition.put("sql", "SELECT foo FROM bar");
        }), TestIcebergView.versions(42, (ArrayNode array) -> {
            ObjectNode version = array.addObject().put("version-id", 42);
            ObjectNode viewDefinition = version.putObject("view-definition");
            viewDefinition.put("sql", "SELECT foo FROM bar");
            viewDefinition.putObject("schema");
        }));
    }

    private static ObjectNode versions(int currentVersionId, Consumer<ArrayNode> arrayNodeConsumer) {
        return TestIcebergView.versions(TestIcebergView.metadata().put("current-version-id", currentVersionId), arrayNodeConsumer);
    }

    private static ObjectNode versions(ObjectNode container, Consumer<ArrayNode> arrayNodeConsumer) {
        ArrayNode array = container.putArray("versions");
        arrayNodeConsumer.accept(array);
        return container;
    }

    private static ObjectNode metadata() {
        return JsonNodeFactory.instance.objectNode();
    }
}

