/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Operation;

@ParametersAreNonnullByDefault
@Generated(from="LogResponse.LogEntry", generator="Immutables")
@Immutable
public final class ImmutableLogEntry
implements LogResponse.LogEntry {
    private final CommitMeta commitMeta;
    private final List<String> additionalParents;
    @Nullable
    private final String parentCommitHash;
    @Nullable
    private final List<Operation> operations;

    private ImmutableLogEntry(CommitMeta commitMeta, List<String> additionalParents, @Nullable String parentCommitHash, @Nullable List<Operation> operations) {
        this.commitMeta = commitMeta;
        this.additionalParents = additionalParents;
        this.parentCommitHash = parentCommitHash;
        this.operations = operations;
    }

    @Override
    @JsonProperty(value="commitMeta")
    public CommitMeta getCommitMeta() {
        return this.commitMeta;
    }

    @Override
    @JsonProperty(value="additionalParents")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getAdditionalParents() {
        return this.additionalParents;
    }

    @Override
    @JsonProperty(value="parentCommitHash")
    @Nullable
    public String getParentCommitHash() {
        return this.parentCommitHash;
    }

    @Override
    @JsonProperty(value="operations")
    @Nullable
    public List<Operation> getOperations() {
        return this.operations;
    }

    public final ImmutableLogEntry withCommitMeta(CommitMeta value) {
        if (this.commitMeta == value) {
            return this;
        }
        CommitMeta newValue = Objects.requireNonNull(value, "commitMeta");
        return new ImmutableLogEntry(newValue, this.additionalParents, this.parentCommitHash, this.operations);
    }

    public final ImmutableLogEntry withAdditionalParents(String ... elements) {
        List<String> newValue = ImmutableLogEntry.createUnmodifiableList(false, ImmutableLogEntry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLogEntry(this.commitMeta, newValue, this.parentCommitHash, this.operations);
    }

    public final ImmutableLogEntry withAdditionalParents(Iterable<String> elements) {
        if (this.additionalParents == elements) {
            return this;
        }
        List<String> newValue = ImmutableLogEntry.createUnmodifiableList(false, ImmutableLogEntry.createSafeList(elements, true, false));
        return new ImmutableLogEntry(this.commitMeta, newValue, this.parentCommitHash, this.operations);
    }

    public final ImmutableLogEntry withParentCommitHash(@Nullable String value) {
        if (Objects.equals(this.parentCommitHash, value)) {
            return this;
        }
        return new ImmutableLogEntry(this.commitMeta, this.additionalParents, value, this.operations);
    }

    public final ImmutableLogEntry withOperations(Operation ... elements) {
        if (elements == null) {
            return new ImmutableLogEntry(this.commitMeta, this.additionalParents, this.parentCommitHash, null);
        }
        List<Operation> newValue = Arrays.asList(elements) == null ? null : ImmutableLogEntry.createUnmodifiableList(false, ImmutableLogEntry.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLogEntry(this.commitMeta, this.additionalParents, this.parentCommitHash, newValue);
    }

    public final ImmutableLogEntry withOperations(@Nullable Iterable<? extends Operation> elements) {
        if (this.operations == elements) {
            return this;
        }
        List<Operation> newValue = elements == null ? null : ImmutableLogEntry.createUnmodifiableList(false, ImmutableLogEntry.createSafeList(elements, true, false));
        return new ImmutableLogEntry(this.commitMeta, this.additionalParents, this.parentCommitHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogEntry && this.equalTo(0, (ImmutableLogEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableLogEntry another) {
        return this.commitMeta.equals(another.commitMeta) && this.additionalParents.equals(another.additionalParents) && Objects.equals(this.parentCommitHash, another.parentCommitHash) && Objects.equals(this.operations, another.operations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commitMeta.hashCode();
        h += (h << 5) + this.additionalParents.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentCommitHash);
        h += (h << 5) + Objects.hashCode(this.operations);
        return h;
    }

    public String toString() {
        return "LogEntry{commitMeta=" + this.commitMeta + ", additionalParents=" + this.additionalParents + ", parentCommitHash=" + this.parentCommitHash + ", operations=" + this.operations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogEntry fromJson(Json json) {
        Builder builder = ImmutableLogEntry.builder();
        if (json.commitMeta != null) {
            builder.commitMeta(json.commitMeta);
        }
        if (json.additionalParents != null) {
            builder.addAllAdditionalParents(json.additionalParents);
        }
        if (json.parentCommitHash != null) {
            builder.parentCommitHash(json.parentCommitHash);
        }
        if (json.operations != null) {
            builder.addAllOperations(json.operations);
        }
        return builder.build();
    }

    public static ImmutableLogEntry copyOf(LogResponse.LogEntry instance) {
        if (instance instanceof ImmutableLogEntry) {
            return (ImmutableLogEntry)instance;
        }
        return ImmutableLogEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LogResponse.LogEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT_META = 1L;
        private long initBits = 1L;
        @Nullable
        private CommitMeta commitMeta;
        private List<String> additionalParents = new ArrayList<String>();
        @Nullable
        private String parentCommitHash;
        private List<Operation> operations = null;

        private Builder() {
        }

        public final Builder from(LogResponse.LogEntry instance) {
            List<Operation> operationsValue;
            Objects.requireNonNull(instance, "instance");
            this.commitMeta(instance.getCommitMeta());
            this.addAllAdditionalParents(instance.getAdditionalParents());
            String parentCommitHashValue = instance.getParentCommitHash();
            if (parentCommitHashValue != null) {
                this.parentCommitHash(parentCommitHashValue);
            }
            if ((operationsValue = instance.getOperations()) != null) {
                this.addAllOperations(operationsValue);
            }
            return this;
        }

        @JsonProperty(value="commitMeta")
        public final Builder commitMeta(CommitMeta commitMeta) {
            this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAdditionalParents(String element) {
            this.additionalParents.add(Objects.requireNonNull(element, "additionalParents element"));
            return this;
        }

        public final Builder addAdditionalParents(String ... elements) {
            for (String element : elements) {
                this.additionalParents.add(Objects.requireNonNull(element, "additionalParents element"));
            }
            return this;
        }

        @JsonProperty(value="additionalParents")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder additionalParents(Iterable<String> elements) {
            this.additionalParents.clear();
            return this.addAllAdditionalParents(elements);
        }

        public final Builder addAllAdditionalParents(Iterable<String> elements) {
            for (String element : elements) {
                this.additionalParents.add(Objects.requireNonNull(element, "additionalParents element"));
            }
            return this;
        }

        @JsonProperty(value="parentCommitHash")
        public final Builder parentCommitHash(@Nullable String parentCommitHash) {
            this.parentCommitHash = parentCommitHash;
            return this;
        }

        public final Builder addOperations(Operation element) {
            if (this.operations == null) {
                this.operations = new ArrayList<Operation>();
            }
            this.operations.add(Objects.requireNonNull(element, "operations element"));
            return this;
        }

        public final Builder addOperations(Operation ... elements) {
            if (this.operations == null) {
                this.operations = new ArrayList<Operation>();
            }
            for (Operation element : elements) {
                this.operations.add(Objects.requireNonNull(element, "operations element"));
            }
            return this;
        }

        @JsonProperty(value="operations")
        public final Builder operations(@Nullable Iterable<? extends Operation> elements) {
            if (elements == null) {
                this.operations = null;
                return this;
            }
            this.operations = new ArrayList<Operation>();
            return this.addAllOperations(elements);
        }

        public final Builder addAllOperations(Iterable<? extends Operation> elements) {
            Objects.requireNonNull(elements, "operations element");
            if (this.operations == null) {
                this.operations = new ArrayList<Operation>();
            }
            for (Operation operation : elements) {
                this.operations.add(Objects.requireNonNull(operation, "operations element"));
            }
            return this;
        }

        public ImmutableLogEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogEntry(this.commitMeta, ImmutableLogEntry.createUnmodifiableList(true, this.additionalParents), this.parentCommitHash, this.operations == null ? null : ImmutableLogEntry.createUnmodifiableList(true, this.operations));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commitMeta");
            }
            return "Cannot build LogEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LogResponse.LogEntry", generator="Immutables")
    static final class Json
    implements LogResponse.LogEntry {
        @Nullable
        CommitMeta commitMeta;
        @Nullable
        List<String> additionalParents = Collections.emptyList();
        @Nullable
        String parentCommitHash;
        @Nullable
        List<Operation> operations = null;

        Json() {
        }

        @JsonProperty(value="commitMeta")
        public void setCommitMeta(CommitMeta commitMeta) {
            this.commitMeta = commitMeta;
        }

        @JsonProperty(value="additionalParents")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setAdditionalParents(List<String> additionalParents) {
            this.additionalParents = additionalParents;
        }

        @JsonProperty(value="parentCommitHash")
        public void setParentCommitHash(@Nullable String parentCommitHash) {
            this.parentCommitHash = parentCommitHash;
        }

        @JsonProperty(value="operations")
        public void setOperations(@Nullable List<Operation> operations) {
            this.operations = operations;
        }

        @Override
        public CommitMeta getCommitMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAdditionalParents() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentCommitHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Operation> getOperations() {
            throw new UnsupportedOperationException();
        }
    }
}

