/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.PaginatedResponse;

@ParametersAreNonnullByDefault
@Generated(from="LogResponse", generator="Immutables")
@Immutable
public final class ImmutableLogResponse
implements LogResponse {
    private final boolean isHasMore;
    @Nullable
    private final String token;
    private final List<LogResponse.LogEntry> logEntries;

    private ImmutableLogResponse(Builder builder) {
        this.token = builder.token;
        this.logEntries = ImmutableLogResponse.createUnmodifiableList(true, builder.logEntries);
        this.isHasMore = builder.isHasMoreIsSet() ? builder.isHasMore : LogResponse.super.isHasMore();
    }

    private ImmutableLogResponse(boolean isHasMore, @Nullable String token, List<LogResponse.LogEntry> logEntries) {
        this.isHasMore = isHasMore;
        this.token = token;
        this.logEntries = logEntries;
    }

    @Override
    @JsonProperty(value="hasMore")
    public boolean isHasMore() {
        return this.isHasMore;
    }

    @Override
    @JsonProperty(value="token")
    @Nullable
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="logEntries")
    public List<LogResponse.LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public final ImmutableLogResponse withIsHasMore(boolean value) {
        if (this.isHasMore == value) {
            return this;
        }
        return new ImmutableLogResponse(value, this.token, this.logEntries);
    }

    public final ImmutableLogResponse withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableLogResponse(this.isHasMore, value, this.logEntries);
    }

    public final ImmutableLogResponse withLogEntries(LogResponse.LogEntry ... elements) {
        List<LogResponse.LogEntry> newValue = ImmutableLogResponse.createUnmodifiableList(false, ImmutableLogResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLogResponse(this.isHasMore, this.token, newValue);
    }

    public final ImmutableLogResponse withLogEntries(Iterable<? extends LogResponse.LogEntry> elements) {
        if (this.logEntries == elements) {
            return this;
        }
        List<LogResponse.LogEntry> newValue = ImmutableLogResponse.createUnmodifiableList(false, ImmutableLogResponse.createSafeList(elements, true, false));
        return new ImmutableLogResponse(this.isHasMore, this.token, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogResponse && this.equalTo(0, (ImmutableLogResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableLogResponse another) {
        return this.isHasMore == another.isHasMore && Objects.equals(this.token, another.token) && this.logEntries.equals(another.logEntries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isHasMore);
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.logEntries.hashCode();
        return h;
    }

    public String toString() {
        return "LogResponse{isHasMore=" + this.isHasMore + ", token=" + this.token + ", logEntries=" + this.logEntries + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogResponse fromJson(Json json) {
        Builder builder = ImmutableLogResponse.builder();
        if (json.isHasMoreIsSet) {
            builder.isHasMore(json.isHasMore);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.logEntries != null) {
            builder.addAllLogEntries(json.logEntries);
        }
        return builder.build();
    }

    public static ImmutableLogResponse copyOf(LogResponse instance) {
        if (instance instanceof ImmutableLogResponse) {
            return (ImmutableLogResponse)instance;
        }
        return ImmutableLogResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LogResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IS_HAS_MORE = 1L;
        private long optBits;
        private boolean isHasMore;
        @Nullable
        private String token;
        private List<LogResponse.LogEntry> logEntries = new ArrayList<LogResponse.LogEntry>();

        private Builder() {
        }

        public final Builder from(LogResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tokenValue;
            PaginatedResponse instance;
            long bits = 0L;
            if (object instanceof LogResponse) {
                instance = (LogResponse)object;
                this.addAllLogEntries(instance.getLogEntries());
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof PaginatedResponse) {
                instance = (PaginatedResponse)object;
                if ((bits & 2L) == 0L) {
                    this.isHasMore(instance.isHasMore());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    tokenValue = instance.getToken();
                    if (tokenValue != null) {
                        this.token(tokenValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="hasMore")
        public final Builder isHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="token")
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        public final Builder addLogEntries(LogResponse.LogEntry element) {
            this.logEntries.add(Objects.requireNonNull(element, "logEntries element"));
            return this;
        }

        public final Builder addLogEntries(LogResponse.LogEntry ... elements) {
            for (LogResponse.LogEntry element : elements) {
                this.logEntries.add(Objects.requireNonNull(element, "logEntries element"));
            }
            return this;
        }

        @JsonProperty(value="logEntries")
        public final Builder logEntries(Iterable<? extends LogResponse.LogEntry> elements) {
            this.logEntries.clear();
            return this.addAllLogEntries(elements);
        }

        public final Builder addAllLogEntries(Iterable<? extends LogResponse.LogEntry> elements) {
            for (LogResponse.LogEntry logEntry : elements) {
                this.logEntries.add(Objects.requireNonNull(logEntry, "logEntries element"));
            }
            return this;
        }

        public ImmutableLogResponse build() {
            return new ImmutableLogResponse(this);
        }

        private boolean isHasMoreIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LogResponse", generator="Immutables")
    static final class Json
    implements LogResponse {
        boolean isHasMore;
        boolean isHasMoreIsSet;
        @Nullable
        String token;
        @Nullable
        List<LogResponse.LogEntry> logEntries = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="hasMore")
        public void setIsHasMore(boolean isHasMore) {
            this.isHasMore = isHasMore;
            this.isHasMoreIsSet = true;
        }

        @JsonProperty(value="token")
        public void setToken(@Nullable String token) {
            this.token = token;
        }

        @JsonProperty(value="logEntries")
        public void setLogEntries(List<LogResponse.LogEntry> logEntries) {
            this.logEntries = logEntries;
        }

        @Override
        public boolean isHasMore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<LogResponse.LogEntry> getLogEntries() {
            throw new UnsupportedOperationException();
        }
    }
}

