/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableAddedContent;
import org.projectnessie.model.ImmutableCommitResponse;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="Commit Response")
@JsonSerialize(as=ImmutableCommitResponse.class)
@JsonDeserialize(as=ImmutableCommitResponse.class)
@Value.Immutable
public interface CommitResponse {
    public static ImmutableCommitResponse.Builder builder() {
        return ImmutableCommitResponse.builder();
    }

    @NotNull
    public Branch getTargetBranch();

    @JsonView(value={Views.V2.class})
    @Nullable
    public List<AddedContent> getAddedContents();

    @JsonSerialize(as=ImmutableAddedContent.class)
    @JsonDeserialize(as=ImmutableAddedContent.class)
    @Value.Immutable
    public static interface AddedContent {
        @NotNull
        @Value.Parameter(order=1)
        public ContentKey getKey();

        @NotNull
        @Value.Parameter(order=2)
        public String contentId();

        public static AddedContent addedContent(ContentKey key, String contentId) {
            return ImmutableAddedContent.of(key, contentId);
        }
    }
}

