/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableContentWithKey;
import org.projectnessie.model.ImmutableGetMultipleContentsResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ser.Views;

@Schema(type=SchemaType.OBJECT, title="GetMultipleContentsResponse")
@JsonSerialize(as=ImmutableGetMultipleContentsResponse.class)
@JsonDeserialize(as=ImmutableGetMultipleContentsResponse.class)
@Value.Immutable
public interface GetMultipleContentsResponse {
    @javax.validation.constraints.NotNull
    @NotNull
    @Value.Parameter(order=1)
    public List<ContentWithKey> getContents();

    @Nullable
    @jakarta.annotation.Nullable
    @JsonView(value={Views.V2.class})
    @Value.Parameter(order=2)
    public Reference getEffectiveReference();

    @Value.NonAttribute
    default public Map<ContentKey, Content> toContentsMap() {
        return this.getContents().stream().collect(Collectors.toMap(ContentWithKey::getKey, ContentWithKey::getContent));
    }

    public static GetMultipleContentsResponse of(List<ContentWithKey> items, Reference effectiveReference) {
        return ImmutableGetMultipleContentsResponse.of(items, effectiveReference);
    }

    @JsonSerialize(as=ImmutableContentWithKey.class)
    @JsonDeserialize(as=ImmutableContentWithKey.class)
    @Value.Immutable
    public static interface ContentWithKey {
        @javax.validation.constraints.NotNull
        @NotNull
        public ContentKey getKey();

        @javax.validation.constraints.NotNull
        @NotNull
        public Content getContent();

        public static ContentWithKey of(ContentKey key, Content content) {
            return ImmutableContentWithKey.builder().key(key).content(content).build();
        }
    }
}

