/*
 * Copyright (C) 2022 Dremio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.projectnessie.api.v1.params;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.MergeResponse;
import org.projectnessie.model.Validation;

public interface BaseMergeTransplant {

  @NotBlank
  @jakarta.validation.constraints.NotBlank
  @Pattern(regexp = Validation.REF_NAME_REGEX, message = Validation.REF_NAME_MESSAGE)
  @jakarta.validation.constraints.Pattern(
      regexp = Validation.REF_NAME_REGEX,
      message = Validation.REF_NAME_MESSAGE)
  String getFromRefName();

  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  Boolean keepIndividualCommits();

  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  List<MergeKeyBehavior> getKeyMergeModes();

  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  MergeBehavior getDefaultKeyMergeMode();

  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  Boolean isDryRun();

  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  Boolean isFetchAdditionalInfo();

  /**
   * When set to {@code true}, the {@code Merge} and {@code Transplant} operations will return
   * {@link MergeResponse} object when a content based conflict cannot be resolved, instead of
   * throwing a {@link org.projectnessie.error.NessieReferenceConflictException}.
   */
  @Nullable
  @jakarta.annotation.Nullable
  @JsonInclude(Include.NON_NULL)
  Boolean isReturnConflictAsResult();
}
