package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EntriesResponse.Entry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntry.builder()}.
 */
@Generated(from = "EntriesResponse.Entry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEntry implements EntriesResponse.Entry {
  private final Contents.Type type;
  private final ContentsKey name;
  private transient final int hashCode;

  private ImmutableEntry(Contents.Type type, ContentsKey name) {
    this.type = type;
    this.name = name;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public Contents.Type getType() {
    return type;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public ContentsKey getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EntriesResponse.Entry#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withType(Contents.Type value) {
    if (this.type == value) return this;
    Contents.Type newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableEntry(newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EntriesResponse.Entry#getName() name} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntry withName(ContentsKey value) {
    if (this.name == value) return this;
    ContentsKey newValue = Objects.requireNonNull(value, "name");
    return new ImmutableEntry(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntry
        && equalTo((ImmutableEntry) another);
  }

  private boolean equalTo(ImmutableEntry another) {
    if (hashCode != another.hashCode) return false;
    return type.equals(another.type)
        && name.equals(another.name);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code type}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Entry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Entry{"
        + "type=" + type
        + ", name=" + name
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "EntriesResponse.Entry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements EntriesResponse.Entry {
    @Nullable Contents.Type type;
    @Nullable ContentsKey name;
    @JsonProperty("type")
    public void setType(Contents.Type type) {
      this.type = type;
    }
    @JsonProperty("name")
    public void setName(ContentsKey name) {
      this.name = name;
    }
    @Override
    public Contents.Type getType() { throw new UnsupportedOperationException(); }
    @Override
    public ContentsKey getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableEntry fromJson(Json json) {
    ImmutableEntry.Builder builder = ImmutableEntry.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link EntriesResponse.Entry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Entry instance
   */
  public static ImmutableEntry copyOf(EntriesResponse.Entry instance) {
    if (instance instanceof ImmutableEntry) {
      return (ImmutableEntry) instance;
    }
    return ImmutableEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntry ImmutableEntry}.
   * <pre>
   * ImmutableEntry.builder()
   *    .type(org.projectnessie.model.Contents.Type) // required {@link EntriesResponse.Entry#getType() type}
   *    .name(org.projectnessie.model.ContentsKey) // required {@link EntriesResponse.Entry#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableEntry builder
   */
  public static ImmutableEntry.Builder builder() {
    return new ImmutableEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEntry ImmutableEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EntriesResponse.Entry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Contents.Type type;
    private @Nullable ContentsKey name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Entry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(EntriesResponse.Entry instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link EntriesResponse.Entry#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(Contents.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link EntriesResponse.Entry#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(ContentsKey name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntry ImmutableEntry}.
     * @return An immutable instance of Entry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEntry(type, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Entry, some of required attributes are not set " + attributes;
    }
  }
}
