package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MultiGetContentsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMultiGetContentsRequest.builder()}.
 */
@Generated(from = "MultiGetContentsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMultiGetContentsRequest implements MultiGetContentsRequest {
  private final List<ContentsKey> requestedKeys;
  private transient final int hashCode;

  private ImmutableMultiGetContentsRequest(List<ContentsKey> requestedKeys) {
    this.requestedKeys = requestedKeys;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code requestedKeys} attribute
   */
  @JsonProperty("requestedKeys")
  @Override
  public List<ContentsKey> getRequestedKeys() {
    return requestedKeys;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMultiGetContentsRequest withRequestedKeys(ContentsKey... elements) {
    List<ContentsKey> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableMultiGetContentsRequest(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requestedKeys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMultiGetContentsRequest withRequestedKeys(Iterable<? extends ContentsKey> elements) {
    if (this.requestedKeys == elements) return this;
    List<ContentsKey> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableMultiGetContentsRequest(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMultiGetContentsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMultiGetContentsRequest
        && equalTo((ImmutableMultiGetContentsRequest) another);
  }

  private boolean equalTo(ImmutableMultiGetContentsRequest another) {
    if (hashCode != another.hashCode) return false;
    return requestedKeys.equals(another.requestedKeys);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code requestedKeys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + requestedKeys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MultiGetContentsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MultiGetContentsRequest{"
        + "requestedKeys=" + requestedKeys
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MultiGetContentsRequest", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MultiGetContentsRequest {
    @Nullable List<ContentsKey> requestedKeys = Collections.emptyList();
    @JsonProperty("requestedKeys")
    public void setRequestedKeys(List<ContentsKey> requestedKeys) {
      this.requestedKeys = requestedKeys;
    }
    @Override
    public List<ContentsKey> getRequestedKeys() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMultiGetContentsRequest fromJson(Json json) {
    ImmutableMultiGetContentsRequest.Builder builder = ImmutableMultiGetContentsRequest.builder();
    if (json.requestedKeys != null) {
      builder.addAllRequestedKeys(json.requestedKeys);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MultiGetContentsRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MultiGetContentsRequest instance
   */
  public static ImmutableMultiGetContentsRequest copyOf(MultiGetContentsRequest instance) {
    if (instance instanceof ImmutableMultiGetContentsRequest) {
      return (ImmutableMultiGetContentsRequest) instance;
    }
    return ImmutableMultiGetContentsRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMultiGetContentsRequest ImmutableMultiGetContentsRequest}.
   * <pre>
   * ImmutableMultiGetContentsRequest.builder()
   *    .addRequestedKeys|addAllRequestedKeys(org.projectnessie.model.ContentsKey) // {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMultiGetContentsRequest builder
   */
  public static ImmutableMultiGetContentsRequest.Builder builder() {
    return new ImmutableMultiGetContentsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMultiGetContentsRequest ImmutableMultiGetContentsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MultiGetContentsRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<ContentsKey> requestedKeys = new ArrayList<ContentsKey>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MultiGetContentsRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MultiGetContentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRequestedKeys(instance.getRequestedKeys());
      return this;
    }

    /**
     * Adds one element to {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys} list.
     * @param element A requestedKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedKeys(ContentsKey element) {
      this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
      return this;
    }

    /**
     * Adds elements to {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys} list.
     * @param elements An array of requestedKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedKeys(ContentsKey... elements) {
      for (ContentsKey element : elements) {
        this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys} list.
     * @param elements An iterable of requestedKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("requestedKeys")
    public final Builder requestedKeys(Iterable<? extends ContentsKey> elements) {
      this.requestedKeys.clear();
      return addAllRequestedKeys(elements);
    }

    /**
     * Adds elements to {@link MultiGetContentsRequest#getRequestedKeys() requestedKeys} list.
     * @param elements An iterable of requestedKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequestedKeys(Iterable<? extends ContentsKey> elements) {
      for (ContentsKey element : elements) {
        this.requestedKeys.add(Objects.requireNonNull(element, "requestedKeys element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMultiGetContentsRequest ImmutableMultiGetContentsRequest}.
     * @return An immutable instance of MultiGetContentsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMultiGetContentsRequest build() {
      return new ImmutableMultiGetContentsRequest(createUnmodifiableList(true, requestedKeys));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
