/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.ContentsKey;

class TestContentsKeyEncoding {
    TestContentsKeyEncoding() {
    }

    @Test
    void singleByte() {
        this.assertRoundTrip("a.b", "c.d");
    }

    @Test
    void strangeCharacters() {
        this.assertRoundTrip("/%", "#&&");
    }

    @Test
    void doubleByte() {
        this.assertRoundTrip("/%\u56fd", "\u56fd.\u56fd");
    }

    @Test
    void blockZeroByteUsage() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ContentsKey.of((String[])new String[]{"\u0000"}));
    }

    private void assertRoundTrip(String ... elements) {
        ContentsKey k = ContentsKey.of((String[])elements);
        ContentsKey k2 = ContentsKey.fromPathString((String)k.toPathString());
        Assertions.assertEquals((Object)k, (Object)k2);
    }
}

