/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.HiveDatabase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HiveDatabase", generator="Immutables")
@Immutable
public final class ImmutableHiveDatabase
extends HiveDatabase {
    @Nullable
    private final String id;
    private final byte[] databaseDefinition;
    private final transient int hashCode;

    private ImmutableHiveDatabase(Builder builder) {
        this.databaseDefinition = builder.databaseDefinition;
        this.id = builder.idIsSet() ? builder.id : super.getId();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableHiveDatabase(@Nullable String id, byte[] databaseDefinition) {
        this.id = id;
        this.databaseDefinition = databaseDefinition;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="databaseDefinition")
    public byte[] getDatabaseDefinition() {
        return (byte[])this.databaseDefinition.clone();
    }

    public final ImmutableHiveDatabase withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableHiveDatabase(value, this.databaseDefinition);
    }

    public final ImmutableHiveDatabase withDatabaseDefinition(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableHiveDatabase(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveDatabase && this.equalTo((ImmutableHiveDatabase)another);
    }

    private boolean equalTo(ImmutableHiveDatabase another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.id, another.id) && Arrays.equals(this.databaseDefinition, another.databaseDefinition);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Arrays.hashCode(this.databaseDefinition);
        return h;
    }

    public String toString() {
        return "HiveDatabase{id=" + this.id + ", databaseDefinition=" + Arrays.toString(this.databaseDefinition) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHiveDatabase fromJson(Json json) {
        Builder builder = ImmutableHiveDatabase.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.databaseDefinition != null) {
            builder.databaseDefinition(json.databaseDefinition);
        }
        return builder.build();
    }

    public static ImmutableHiveDatabase copyOf(HiveDatabase instance) {
        if (instance instanceof ImmutableHiveDatabase) {
            return (ImmutableHiveDatabase)instance;
        }
        return ImmutableHiveDatabase.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HiveDatabase", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_DEFINITION = 1L;
        private static final long OPT_BIT_ID = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private byte[] databaseDefinition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HiveDatabase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Contents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String idValue;
            Contents instance;
            if (object instanceof HiveDatabase) {
                instance = (HiveDatabase)object;
                this.databaseDefinition(((HiveDatabase)instance).getDatabaseDefinition());
            }
            if (object instanceof Contents && (idValue = (instance = (Contents)object).getId()) != null) {
                this.id(idValue);
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="databaseDefinition")
        @CanIgnoreReturnValue
        public final Builder databaseDefinition(byte ... databaseDefinition) {
            this.databaseDefinition = (byte[])databaseDefinition.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHiveDatabase build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHiveDatabase(this);
        }

        private boolean idIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseDefinition");
            }
            return "Cannot build HiveDatabase, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HiveDatabase", generator="Immutables")
    static final class Json
    extends HiveDatabase {
        @Nullable
        String id;
        boolean idIsSet;
        @Nullable
        byte[] databaseDefinition;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="databaseDefinition")
        public void setDatabaseDefinition(byte[] databaseDefinition) {
            this.databaseDefinition = databaseDefinition;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getDatabaseDefinition() {
            throw new UnsupportedOperationException();
        }
    }
}

