package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Operations}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOperations.builder()}.
 */
@Generated(from = "Operations", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOperations implements Operations {
  private final CommitMeta commitMeta;
  private final List<Operation> operations;
  private transient final int hashCode;

  private ImmutableOperations(
      CommitMeta commitMeta,
      List<Operation> operations) {
    this.commitMeta = commitMeta;
    this.operations = operations;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code commitMeta} attribute
   */
  @JsonProperty("commitMeta")
  @Override
  public CommitMeta getCommitMeta() {
    return commitMeta;
  }

  /**
   * @return The value of the {@code operations} attribute
   */
  @JsonProperty("operations")
  @Override
  public List<Operation> getOperations() {
    return operations;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Operations#getCommitMeta() commitMeta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitMeta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOperations withCommitMeta(CommitMeta value) {
    if (this.commitMeta == value) return this;
    CommitMeta newValue = Objects.requireNonNull(value, "commitMeta");
    return new ImmutableOperations(newValue, this.operations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Operations#getOperations() operations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperations withOperations(Operation... elements) {
    List<Operation> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableOperations(this.commitMeta, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Operations#getOperations() operations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of operations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOperations withOperations(Iterable<? extends Operation> elements) {
    if (this.operations == elements) return this;
    List<Operation> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableOperations(this.commitMeta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOperations} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOperations
        && equalTo((ImmutableOperations) another);
  }

  private boolean equalTo(ImmutableOperations another) {
    if (hashCode != another.hashCode) return false;
    return commitMeta.equals(another.commitMeta)
        && operations.equals(another.operations);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code commitMeta}, {@code operations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + commitMeta.hashCode();
    h += (h << 5) + operations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Operations} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Operations{"
        + "commitMeta=" + commitMeta
        + ", operations=" + operations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Operations", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Operations {
    @Nullable CommitMeta commitMeta;
    @Nullable List<Operation> operations = Collections.emptyList();
    @JsonProperty("commitMeta")
    public void setCommitMeta(CommitMeta commitMeta) {
      this.commitMeta = commitMeta;
    }
    @JsonProperty("operations")
    public void setOperations(List<Operation> operations) {
      this.operations = operations;
    }
    @Override
    public CommitMeta getCommitMeta() { throw new UnsupportedOperationException(); }
    @Override
    public List<Operation> getOperations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOperations fromJson(Json json) {
    ImmutableOperations.Builder builder = ImmutableOperations.builder();
    if (json.commitMeta != null) {
      builder.commitMeta(json.commitMeta);
    }
    if (json.operations != null) {
      builder.addAllOperations(json.operations);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Operations} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Operations instance
   */
  public static ImmutableOperations copyOf(Operations instance) {
    if (instance instanceof ImmutableOperations) {
      return (ImmutableOperations) instance;
    }
    return ImmutableOperations.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOperations ImmutableOperations}.
   * <pre>
   * ImmutableOperations.builder()
   *    .commitMeta(org.projectnessie.model.CommitMeta) // required {@link Operations#getCommitMeta() commitMeta}
   *    .addOperations|addAllOperations(org.projectnessie.model.Operation) // {@link Operations#getOperations() operations} elements
   *    .build();
   * </pre>
   * @return A new ImmutableOperations builder
   */
  public static ImmutableOperations.Builder builder() {
    return new ImmutableOperations.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOperations ImmutableOperations}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Operations", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMMIT_META = 0x1L;
    private long initBits = 0x1L;

    private @Nullable CommitMeta commitMeta;
    private List<Operation> operations = new ArrayList<Operation>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Operations} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Operations instance) {
      Objects.requireNonNull(instance, "instance");
      commitMeta(instance.getCommitMeta());
      addAllOperations(instance.getOperations());
      return this;
    }

    /**
     * Initializes the value for the {@link Operations#getCommitMeta() commitMeta} attribute.
     * @param commitMeta The value for commitMeta 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("commitMeta")
    public final Builder commitMeta(CommitMeta commitMeta) {
      this.commitMeta = Objects.requireNonNull(commitMeta, "commitMeta");
      initBits &= ~INIT_BIT_COMMIT_META;
      return this;
    }

    /**
     * Adds one element to {@link Operations#getOperations() operations} list.
     * @param element A operations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(Operation element) {
      this.operations.add(Objects.requireNonNull(element, "operations element"));
      return this;
    }

    /**
     * Adds elements to {@link Operations#getOperations() operations} list.
     * @param elements An array of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(Operation... elements) {
      for (Operation element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Operations#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operations")
    public final Builder operations(Iterable<? extends Operation> elements) {
      this.operations.clear();
      return addAllOperations(elements);
    }

    /**
     * Adds elements to {@link Operations#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOperations(Iterable<? extends Operation> elements) {
      for (Operation element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableOperations ImmutableOperations}.
     * @return An immutable instance of Operations
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOperations build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOperations(commitMeta, createUnmodifiableList(true, operations));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMMIT_META) != 0) attributes.add("commitMeta");
      return "Cannot build Operations, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
