package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Hash}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHash.builder()}.
 */
@Generated(from = "Hash", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHash extends Hash {
  private final String name;
  private transient final String hash;
  private transient final int hashCode;

  private ImmutableHash(String name) {
    this.name = name;
    this.hash = Objects.requireNonNull(super.getHash(), "hash");
    this.hashCode = computeHashCode();
  }

  /**
   *Human readable reference name. 
   */
  @JsonProperty("name")
  @JsonFormat(pattern = "^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The computed-at-construction value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Hash#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHash withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return validate(new ImmutableHash(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHash} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHash
        && equalTo((ImmutableHash) another);
  }

  private boolean equalTo(ImmutableHash another) {
    if (hashCode != another.hashCode) return false;
    return name.equals(another.name)
        && hash.equals(another.hash);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code name}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + hash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Hash} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Hash{"
        + "name=" + name
        + ", hash=" + hash
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Hash", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Hash {
    @Nullable String name;
    @JsonProperty("name")
    @JsonFormat(pattern = "^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHash fromJson(Json json) {
    ImmutableHash.Builder builder = ImmutableHash.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  private static ImmutableHash validate(ImmutableHash instance) {
    instance.checkHash();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Hash} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Hash instance
   */
  public static ImmutableHash copyOf(Hash instance) {
    if (instance instanceof ImmutableHash) {
      return (ImmutableHash) instance;
    }
    return ImmutableHash.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHash ImmutableHash}.
   * <pre>
   * ImmutableHash.builder()
   *    .name(String) // required {@link Hash#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableHash builder
   */
  public static ImmutableHash.Builder builder() {
    return new ImmutableHash.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHash ImmutableHash}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Hash", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Reference} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Reference instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Hash} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Hash instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Reference) {
        Reference instance = (Reference) object;
        name(instance.getName());
      }
    }

    /**
     * Initializes the value for the {@link Hash#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    @JsonFormat(pattern = "^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHash ImmutableHash}.
     * @return An immutable instance of Hash
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHash build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableHash.validate(new ImmutableHash(name));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Hash, some of required attributes are not set " + attributes;
    }
  }
}
