package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.Size;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HiveDatabase}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHiveDatabase.builder()}.
 */
@Generated(from = "HiveDatabase", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHiveDatabase extends HiveDatabase {
  private final String id;
  private final @Size(min=1) byte[] databaseDefinition;
  private transient final int hashCode;

  private ImmutableHiveDatabase(ImmutableHiveDatabase.Builder builder) {
    this.databaseDefinition = builder.databaseDefinition;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
    this.hashCode = computeHashCode();
  }

  private ImmutableHiveDatabase(String id, @Size(min=1) byte[] databaseDefinition) {
    this.id = id;
    this.databaseDefinition = databaseDefinition;
    this.hashCode = computeHashCode();
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Contents object and persists across
   * renames. Two contents with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return A cloned {@code databaseDefinition} array
   */
  @JsonProperty("databaseDefinition")
  @Override
  public @Size(min=1) byte[] getDatabaseDefinition() {
    return databaseDefinition.clone();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HiveDatabase#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHiveDatabase withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableHiveDatabase(newValue, this.databaseDefinition);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HiveDatabase#getDatabaseDefinition() databaseDefinition}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for databaseDefinition
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHiveDatabase withDatabaseDefinition(@Size(min=1) byte... elements) {
    @Size(min=1) byte[] newValue = elements.clone();
    return new ImmutableHiveDatabase(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHiveDatabase} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHiveDatabase
        && equalTo((ImmutableHiveDatabase) another);
  }

  private boolean equalTo(ImmutableHiveDatabase another) {
    if (hashCode != another.hashCode) return false;
    return id.equals(another.id)
        && Arrays.equals(databaseDefinition, another.databaseDefinition);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code id}, {@code databaseDefinition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Arrays.hashCode(databaseDefinition);
    return h;
  }

  /**
   * Prints the immutable value {@code HiveDatabase} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HiveDatabase{"
        + "id=" + id
        + ", databaseDefinition=" + Arrays.toString(databaseDefinition)
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "HiveDatabase", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends HiveDatabase {
    @Nullable String id;
    @Nullable @Size(min=1) byte[] databaseDefinition;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("databaseDefinition")
    public void setDatabaseDefinition(@Size(min=1) byte[] databaseDefinition) {
      this.databaseDefinition = databaseDefinition;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public @Size(min=1) byte[] getDatabaseDefinition() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHiveDatabase fromJson(Json json) {
    ImmutableHiveDatabase.Builder builder = ImmutableHiveDatabase.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.databaseDefinition != null) {
      builder.databaseDefinition(json.databaseDefinition);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HiveDatabase} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HiveDatabase instance
   */
  public static ImmutableHiveDatabase copyOf(HiveDatabase instance) {
    if (instance instanceof ImmutableHiveDatabase) {
      return (ImmutableHiveDatabase) instance;
    }
    return ImmutableHiveDatabase.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHiveDatabase ImmutableHiveDatabase}.
   * <pre>
   * ImmutableHiveDatabase.builder()
   *    .id(String) // optional {@link HiveDatabase#getId() id}
   *    .databaseDefinition(@javax.validation.constraints.Size(min=1) byte) // required {@link HiveDatabase#getDatabaseDefinition() databaseDefinition}
   *    .build();
   * </pre>
   * @return A new ImmutableHiveDatabase builder
   */
  public static ImmutableHiveDatabase.Builder builder() {
    return new ImmutableHiveDatabase.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHiveDatabase ImmutableHiveDatabase}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HiveDatabase", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DATABASE_DEFINITION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable @Size(min=1) byte[] databaseDefinition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.HiveDatabase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HiveDatabase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Contents} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Contents instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof HiveDatabase) {
        HiveDatabase instance = (HiveDatabase) object;
        databaseDefinition(instance.getDatabaseDefinition());
      }
      if (object instanceof Contents) {
        Contents instance = (Contents) object;
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link HiveDatabase#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link HiveDatabase#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link HiveDatabase#getDatabaseDefinition() databaseDefinition} attribute.
     * @param databaseDefinition The elements for databaseDefinition
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("databaseDefinition")
    public final Builder databaseDefinition(@Size(min=1) byte... databaseDefinition) {
      this.databaseDefinition = databaseDefinition.clone();
      initBits &= ~INIT_BIT_DATABASE_DEFINITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHiveDatabase ImmutableHiveDatabase}.
     * @return An immutable instance of HiveDatabase
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHiveDatabase build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHiveDatabase(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATABASE_DEFINITION) != 0) attributes.add("databaseDefinition");
      return "Cannot build HiveDatabase, some of required attributes are not set " + attributes;
    }
  }
}
