package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.constraints.Size;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HiveTable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHiveTable.builder()}.
 */
@Generated(from = "HiveTable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHiveTable extends HiveTable {
  private final String id;
  private final @Size(min=1) byte[] tableDefinition;
  private final List<byte[]> partitions;
  private transient final int hashCode;

  private ImmutableHiveTable(ImmutableHiveTable.Builder builder) {
    this.tableDefinition = builder.tableDefinition;
    this.partitions = createUnmodifiableList(true, builder.partitions);
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
    this.hashCode = super.hashCode();
  }

  private ImmutableHiveTable(
      String id,
      @Size(min=1) byte[] tableDefinition,
      List<byte[]> partitions) {
    this.id = id;
    this.tableDefinition = tableDefinition;
    this.partitions = partitions;
    this.hashCode = super.hashCode();
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Contents object and persists across
   * renames. Two contents with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return A cloned {@code tableDefinition} array
   */
  @JsonProperty("tableDefinition")
  @Override
  public @Size(min=1) byte[] getTableDefinition() {
    return tableDefinition.clone();
  }

  /**
   * @return The value of the {@code partitions} attribute
   */
  @JsonProperty("partitions")
  @Override
  public List<byte[]> getPartitions() {
    return partitions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HiveTable#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHiveTable withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableHiveTable(newValue, this.tableDefinition, this.partitions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HiveTable#getTableDefinition() tableDefinition}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for tableDefinition
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHiveTable withTableDefinition(@Size(min=1) byte... elements) {
    @Size(min=1) byte[] newValue = elements.clone();
    return new ImmutableHiveTable(this.id, newValue, this.partitions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HiveTable#getPartitions() partitions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHiveTable withPartitions(byte[]... elements) {
    List<byte[]> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableHiveTable(this.id, this.tableDefinition, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link HiveTable#getPartitions() partitions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of partitions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHiveTable withPartitions(Iterable<? extends byte[]> elements) {
    if (this.partitions == elements) return this;
    List<byte[]> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableHiveTable(this.id, this.tableDefinition, newValue);
  }

  /**
   * Returns the precomputed-on-construction hash code from the supertype implementation of {@code super.hashCode()}.
   * @return The hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  /**
   * Prints the immutable value {@code HiveTable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HiveTable{"
        + "id=" + id
        + ", tableDefinition=" + Arrays.toString(tableDefinition)
        + ", partitions=" + partitions
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "HiveTable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends HiveTable {
    @Nullable String id;
    @Nullable @Size(min=1) byte[] tableDefinition;
    @Nullable List<byte[]> partitions = Collections.emptyList();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("tableDefinition")
    public void setTableDefinition(@Size(min=1) byte[] tableDefinition) {
      this.tableDefinition = tableDefinition;
    }
    @JsonProperty("partitions")
    public void setPartitions(List<byte[]> partitions) {
      this.partitions = partitions;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public @Size(min=1) byte[] getTableDefinition() { throw new UnsupportedOperationException(); }
    @Override
    public List<byte[]> getPartitions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHiveTable fromJson(Json json) {
    ImmutableHiveTable.Builder builder = ImmutableHiveTable.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.tableDefinition != null) {
      builder.tableDefinition(json.tableDefinition);
    }
    if (json.partitions != null) {
      builder.addAllPartitions(json.partitions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HiveTable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HiveTable instance
   */
  public static ImmutableHiveTable copyOf(HiveTable instance) {
    if (instance instanceof ImmutableHiveTable) {
      return (ImmutableHiveTable) instance;
    }
    return ImmutableHiveTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHiveTable ImmutableHiveTable}.
   * <pre>
   * ImmutableHiveTable.builder()
   *    .id(String) // optional {@link HiveTable#getId() id}
   *    .tableDefinition(@javax.validation.constraints.Size(min=1) byte) // required {@link HiveTable#getTableDefinition() tableDefinition}
   *    .addPartitions|addAllPartitions(byte[]) // {@link HiveTable#getPartitions() partitions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableHiveTable builder
   */
  public static ImmutableHiveTable.Builder builder() {
    return new ImmutableHiveTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHiveTable ImmutableHiveTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HiveTable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TABLE_DEFINITION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable @Size(min=1) byte[] tableDefinition;
    private List<byte[]> partitions = new ArrayList<byte[]>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Contents} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Contents instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.HiveTable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HiveTable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Contents) {
        Contents instance = (Contents) object;
        id(instance.getId());
      }
      if (object instanceof HiveTable) {
        HiveTable instance = (HiveTable) object;
        addAllPartitions(instance.getPartitions());
        tableDefinition(instance.getTableDefinition());
      }
    }

    /**
     * Initializes the value for the {@link HiveTable#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link HiveTable#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link HiveTable#getTableDefinition() tableDefinition} attribute.
     * @param tableDefinition The elements for tableDefinition
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("tableDefinition")
    public final Builder tableDefinition(@Size(min=1) byte... tableDefinition) {
      this.tableDefinition = tableDefinition.clone();
      initBits &= ~INIT_BIT_TABLE_DEFINITION;
      return this;
    }

    /**
     * Adds one element to {@link HiveTable#getPartitions() partitions} list.
     * @param element A partitions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPartitions(byte[] element) {
      this.partitions.add(Objects.requireNonNull(element, "partitions element"));
      return this;
    }

    /**
     * Adds elements to {@link HiveTable#getPartitions() partitions} list.
     * @param elements An array of partitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPartitions(byte[]... elements) {
      for (byte[] element : elements) {
        this.partitions.add(Objects.requireNonNull(element, "partitions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link HiveTable#getPartitions() partitions} list.
     * @param elements An iterable of partitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("partitions")
    public final Builder partitions(Iterable<? extends byte[]> elements) {
      this.partitions.clear();
      return addAllPartitions(elements);
    }

    /**
     * Adds elements to {@link HiveTable#getPartitions() partitions} list.
     * @param elements An iterable of partitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPartitions(Iterable<? extends byte[]> elements) {
      for (byte[] element : elements) {
        this.partitions.add(Objects.requireNonNull(element, "partitions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableHiveTable ImmutableHiveTable}.
     * @return An immutable instance of HiveTable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHiveTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHiveTable(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TABLE_DEFINITION) != 0) attributes.add("tableDefinition");
      return "Cannot build HiveTable, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
