package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IcebergTable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIcebergTable.builder()}.
 */
@Generated(from = "IcebergTable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIcebergTable extends IcebergTable {
  private final String id;
  private final String metadataLocation;
  private transient final int hashCode;

  private ImmutableIcebergTable(ImmutableIcebergTable.Builder builder) {
    this.metadataLocation = builder.metadataLocation;
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.getId(), "id");
    this.hashCode = computeHashCode();
  }

  private ImmutableIcebergTable(String id, String metadataLocation) {
    this.id = id;
    this.metadataLocation = metadataLocation;
    this.hashCode = computeHashCode();
  }

  /**
   * Unique id for this object.
   * <p>This id is unique for the entire lifetime of this Contents object and persists across
   * renames. Two contents with the same key will have different id.
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code metadataLocation} attribute
   */
  @JsonProperty("metadataLocation")
  @Override
  public String getMetadataLocation() {
    return metadataLocation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableIcebergTable(newValue, this.metadataLocation);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IcebergTable#getMetadataLocation() metadataLocation} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadataLocation
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIcebergTable withMetadataLocation(String value) {
    String newValue = Objects.requireNonNull(value, "metadataLocation");
    if (this.metadataLocation.equals(newValue)) return this;
    return new ImmutableIcebergTable(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIcebergTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIcebergTable
        && equalTo((ImmutableIcebergTable) another);
  }

  private boolean equalTo(ImmutableIcebergTable another) {
    if (hashCode != another.hashCode) return false;
    return id.equals(another.id)
        && metadataLocation.equals(another.metadataLocation);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code id}, {@code metadataLocation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + metadataLocation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IcebergTable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IcebergTable{"
        + "id=" + id
        + ", metadataLocation=" + metadataLocation
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IcebergTable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends IcebergTable {
    @Nullable String id;
    @Nullable String metadataLocation;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("metadataLocation")
    public void setMetadataLocation(String metadataLocation) {
      this.metadataLocation = metadataLocation;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMetadataLocation() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIcebergTable fromJson(Json json) {
    ImmutableIcebergTable.Builder builder = ImmutableIcebergTable.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.metadataLocation != null) {
      builder.metadataLocation(json.metadataLocation);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IcebergTable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IcebergTable instance
   */
  public static ImmutableIcebergTable copyOf(IcebergTable instance) {
    if (instance instanceof ImmutableIcebergTable) {
      return (ImmutableIcebergTable) instance;
    }
    return ImmutableIcebergTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIcebergTable ImmutableIcebergTable}.
   * <pre>
   * ImmutableIcebergTable.builder()
   *    .id(String) // optional {@link IcebergTable#getId() id}
   *    .metadataLocation(String) // required {@link IcebergTable#getMetadataLocation() metadataLocation}
   *    .build();
   * </pre>
   * @return A new ImmutableIcebergTable builder
   */
  public static ImmutableIcebergTable.Builder builder() {
    return new ImmutableIcebergTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIcebergTable ImmutableIcebergTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IcebergTable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_METADATA_LOCATION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String metadataLocation;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.Contents} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Contents instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.IcebergTable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IcebergTable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Contents) {
        Contents instance = (Contents) object;
        id(instance.getId());
      }
      if (object instanceof IcebergTable) {
        IcebergTable instance = (IcebergTable) object;
        metadataLocation(instance.getMetadataLocation());
      }
    }

    /**
     * Initializes the value for the {@link IcebergTable#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link IcebergTable#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link IcebergTable#getMetadataLocation() metadataLocation} attribute.
     * @param metadataLocation The value for metadataLocation 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("metadataLocation")
    public final Builder metadataLocation(String metadataLocation) {
      this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
      initBits &= ~INIT_BIT_METADATA_LOCATION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIcebergTable ImmutableIcebergTable}.
     * @return An immutable instance of IcebergTable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIcebergTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIcebergTable(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA_LOCATION) != 0) attributes.add("metadataLocation");
      return "Cannot build IcebergTable, some of required attributes are not set " + attributes;
    }
  }
}
