/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.ContentsKey;

public class ContentsKeyValidationTest {
    @Test
    public void testValidation() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContentsKey.of((String[])new String[]{"a", "b", "\u0000", "c", "d"})).isInstanceOf(IllegalArgumentException.class)).hasMessage("An object key cannot contain a zero byte.");
    }

    @Test
    public void testConstruction() {
        CharSequence[] elements = new String[]{"a", "b", "c", "d"};
        ContentsKey key = ContentsKey.of((String[])elements);
        Assertions.assertThat((List)key.getElements()).containsExactlyElementsOf(Arrays.asList(elements));
        Assertions.assertThat((String)key.toPathString()).isEqualTo(String.join((CharSequence)".", elements));
        Assertions.assertThat((Object)ContentsKey.fromPathString((String)"a.b.c.d")).isEqualTo((Object)key);
    }
}

