/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Hash;
import org.projectnessie.model.Tag;
import org.projectnessie.model.Validation;

class TestValidation {
    TestValidation() {
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "a_b-", "a_-c", "abc/def"})
    void validRefNames(String referenceName) {
        Validation.validateReferenceName((String)referenceName);
        Validation.validateReferenceNameOrHash((String)referenceName);
        Branch.of((String)referenceName, null);
        Tag.of((String)referenceName, null);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "abc/", ".foo", "abc/def/../blah", "abc/de..blah", "abc/de@{blah"})
    void invalidRefNames(String referenceName) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + referenceName), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateReferenceName((String)referenceName))).getMessage()), () -> Assertions.assertEquals((Object)("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes - but was: " + referenceName), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateReferenceNameOrHash((String)referenceName))).getMessage()), () -> Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + referenceName), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, null))).getMessage()), () -> Assertions.assertEquals((Object)("Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. - but was: " + referenceName), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, null))).getMessage())});
    }

    @Test
    void nullParam() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> Validation.validateReferenceName(null)), () -> Assertions.assertThrows(NullPointerException.class, () -> Hash.of(null)), () -> Assertions.assertThrows(NullPointerException.class, () -> Branch.of(null, null)), () -> Assertions.assertThrows(NullPointerException.class, () -> Tag.of(null, null))});
    }

    @ParameterizedTest
    @ValueSource(strings={"1122334455667788990011223344556677889900112233445566778899001122", "abcDEF4242424242424242424242BEEF00DEAD42112233445566778899001122", "0011223344556677", "11223344556677889900"})
    void validHashes(String hash) {
        Validation.validateHash((String)hash);
        Validation.validateReferenceNameOrHash((String)hash);
        Hash.of((String)hash);
    }

    @ParameterizedTest
    @ValueSource(strings={"", "abc/", ".foo", "abc/def/../blah", "abc/de..blah", "abc/de@{blah"})
    void invalidHashes(String hash) {
        String referenceName = "thisIsAValidName";
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Validation.validateHash((String)hash))).getMessage()), () -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Hash.of((String)hash))).getMessage()), () -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, (String)hash))).getMessage()), () -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, (String)hash))).getMessage())});
    }

    @ParameterizedTest
    @CsvSource(value={"a,112233445566778899001122abcDEF4242424242424242424242BEEF00DEAD42", "a,1122334455667788990011221122334455667788990011223344556677889900", "a_b-,112233445566778899001122abcDEF4242424242424242424242BEEF00DEAD42", "a_b-,1122334455667788990011221122334455667788990011223344556677889900", "a_-c,1122334455667788", "a_-c,112233445566778899001122", "abc/def,1122334455667788990011223344556677889900"})
    void validNamesAndHashes(String referenceName, String hash) {
        Branch.of((String)referenceName, (String)hash);
        Tag.of((String)referenceName, (String)hash);
    }

    @ParameterizedTest
    @CsvSource(value={"a,abcDEF4242424242424242424242BEEF00DEADxy", "a,11", "a_b-,meep", "a_b-,0", "a_-c,##", "a_-c,123", "abc/def,nonono"})
    void validNamesAndInvalidHashes(String referenceName, String hash) {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Branch.of((String)referenceName, (String)hash))).getMessage()), () -> Assertions.assertEquals((Object)("Hash must consist of the hex representation of 8-32 bytes - but was: " + hash), (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Tag.of((String)referenceName, (String)hash))).getMessage())});
    }
}

