package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentsKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsKey.builder()}.
 */
@Generated(from = "ContentsKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsKey extends ContentsKey {
  private final List<String> elements;
  private transient final Namespace namespace;
  private transient final int hashCode;

  private ImmutableContentsKey(List<String> elements) {
    this.elements = elements;
    this.namespace = Objects.requireNonNull(super.getNamespace(), "namespace");
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty("elements")
  @Override
  public List<String> getElements() {
    return elements;
  }

  /**
   * Returns the namespace that is always consisting of the first <b>N-1</b> elements from {@link
   * ContentsKey#getElements()}.
   * @return A {@link Namespace} instance that is always consisting of the first <b>N-1</b> elements
   *     from {@link ContentsKey#getElements()}.
   */
  @JsonProperty("namespace")
  @JsonIgnore
  @Override
  public Namespace getNamespace() {
    return namespace;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContentsKey#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContentsKey withElements(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableContentsKey(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContentsKey#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableContentsKey withElements(Iterable<String> elements) {
    if (this.elements == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableContentsKey(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsKey
        && equalTo((ImmutableContentsKey) another);
  }

  private boolean equalTo(ImmutableContentsKey another) {
    if (hashCode != another.hashCode) return false;
    return elements.equals(another.elements)
        && namespace.equals(another.namespace);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code elements}, {@code namespace}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + elements.hashCode();
    h += (h << 5) + namespace.hashCode();
    return h;
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ContentsKey", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ContentsKey {
    @Nullable List<String> elements = Collections.emptyList();
    @JsonProperty("elements")
    public void setElements(List<String> elements) {
      this.elements = elements;
    }
    @Override
    public List<String> getElements() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public Namespace getNamespace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContentsKey fromJson(Json json) {
    ImmutableContentsKey.Builder builder = ImmutableContentsKey.builder();
    if (json.elements != null) {
      builder.addAllElements(json.elements);
    }
    return builder.build();
  }

  private static ImmutableContentsKey validate(ImmutableContentsKey instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ContentsKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentsKey instance
   */
  public static ImmutableContentsKey copyOf(ContentsKey instance) {
    if (instance instanceof ImmutableContentsKey) {
      return (ImmutableContentsKey) instance;
    }
    return ImmutableContentsKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsKey ImmutableContentsKey}.
   * <pre>
   * ImmutableContentsKey.builder()
   *    .addElements|addAllElements(String) // {@link ContentsKey#getElements() elements} elements
   *    .build();
   * </pre>
   * @return A new ImmutableContentsKey builder
   */
  public static ImmutableContentsKey.Builder builder() {
    return new ImmutableContentsKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentsKey ImmutableContentsKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentsKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<String> elements = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentsKey instance) {
      Objects.requireNonNull(instance, "instance");
      addAllElements(instance.getElements());
      return this;
    }

    /**
     * Adds one element to {@link ContentsKey#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link ContentsKey#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addElements(String... elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ContentsKey#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("elements")
    public final Builder elements(Iterable<String> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link ContentsKey#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllElements(Iterable<String> elements) {
      for (String element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsKey ImmutableContentsKey}.
     * @return An immutable instance of ContentsKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsKey build() {
      return ImmutableContentsKey.validate(new ImmutableContentsKey(createUnmodifiableList(true, elements)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
