package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MultiGetContentsResponse.ContentsWithKey}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentsWithKey.builder()}.
 */
@Generated(from = "MultiGetContentsResponse.ContentsWithKey", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentsWithKey
    implements MultiGetContentsResponse.ContentsWithKey {
  private final ContentsKey key;
  private final Contents contents;
  private transient final int hashCode;

  private ImmutableContentsWithKey(ContentsKey key, Contents contents) {
    this.key = key;
    this.contents = contents;
    this.hashCode = computeHashCode();
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public ContentsKey getKey() {
    return key;
  }

  /**
   * @return The value of the {@code contents} attribute
   */
  @JsonProperty("contents")
  @Override
  public Contents getContents() {
    return contents;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MultiGetContentsResponse.ContentsWithKey#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsWithKey withKey(ContentsKey value) {
    if (this.key == value) return this;
    ContentsKey newValue = Objects.requireNonNull(value, "key");
    return new ImmutableContentsWithKey(newValue, this.contents);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MultiGetContentsResponse.ContentsWithKey#getContents() contents} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contents
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentsWithKey withContents(Contents value) {
    if (this.contents == value) return this;
    Contents newValue = Objects.requireNonNull(value, "contents");
    return new ImmutableContentsWithKey(this.key, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentsWithKey} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentsWithKey
        && equalTo((ImmutableContentsWithKey) another);
  }

  private boolean equalTo(ImmutableContentsWithKey another) {
    if (hashCode != another.hashCode) return false;
    return key.equals(another.key)
        && contents.equals(another.contents);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code key}, {@code contents}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + contents.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ContentsWithKey} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContentsWithKey{"
        + "key=" + key
        + ", contents=" + contents
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MultiGetContentsResponse.ContentsWithKey", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MultiGetContentsResponse.ContentsWithKey {
    @Nullable ContentsKey key;
    @Nullable Contents contents;
    @JsonProperty("key")
    public void setKey(ContentsKey key) {
      this.key = key;
    }
    @JsonProperty("contents")
    public void setContents(Contents contents) {
      this.contents = contents;
    }
    @Override
    public ContentsKey getKey() { throw new UnsupportedOperationException(); }
    @Override
    public Contents getContents() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableContentsWithKey fromJson(Json json) {
    ImmutableContentsWithKey.Builder builder = ImmutableContentsWithKey.builder();
    if (json.key != null) {
      builder.key(json.key);
    }
    if (json.contents != null) {
      builder.contents(json.contents);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MultiGetContentsResponse.ContentsWithKey} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentsWithKey instance
   */
  public static ImmutableContentsWithKey copyOf(MultiGetContentsResponse.ContentsWithKey instance) {
    if (instance instanceof ImmutableContentsWithKey) {
      return (ImmutableContentsWithKey) instance;
    }
    return ImmutableContentsWithKey.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentsWithKey ImmutableContentsWithKey}.
   * <pre>
   * ImmutableContentsWithKey.builder()
   *    .key(org.projectnessie.model.ContentsKey) // required {@link MultiGetContentsResponse.ContentsWithKey#getKey() key}
   *    .contents(org.projectnessie.model.Contents) // required {@link MultiGetContentsResponse.ContentsWithKey#getContents() contents}
   *    .build();
   * </pre>
   * @return A new ImmutableContentsWithKey builder
   */
  public static ImmutableContentsWithKey.Builder builder() {
    return new ImmutableContentsWithKey.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentsWithKey ImmutableContentsWithKey}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MultiGetContentsResponse.ContentsWithKey", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENTS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentsKey key;
    private @Nullable Contents contents;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentsWithKey} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MultiGetContentsResponse.ContentsWithKey instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      contents(instance.getContents());
      return this;
    }

    /**
     * Initializes the value for the {@link MultiGetContentsResponse.ContentsWithKey#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(ContentsKey key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link MultiGetContentsResponse.ContentsWithKey#getContents() contents} attribute.
     * @param contents The value for contents 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contents")
    public final Builder contents(Contents contents) {
      this.contents = Objects.requireNonNull(contents, "contents");
      initBits &= ~INIT_BIT_CONTENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentsWithKey ImmutableContentsWithKey}.
     * @return An immutable instance of ContentsWithKey
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentsWithKey build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentsWithKey(key, contents);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENTS) != 0) attributes.add("contents");
      return "Cannot build ContentsWithKey, some of required attributes are not set " + attributes;
    }
  }
}
