package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LogResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLogResponse.builder()}.
 */
@Generated(from = "LogResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLogResponse implements LogResponse {
  private final boolean hasMore;
  private final @Nullable String token;
  private final List<CommitMeta> operations;
  private transient final int hashCode;

  private ImmutableLogResponse(ImmutableLogResponse.Builder builder) {
    this.token = builder.token;
    this.operations = createUnmodifiableList(true, builder.operations);
    this.hasMore = builder.hasMoreIsSet()
        ? builder.hasMore
        : LogResponse.super.hasMore();
    this.hashCode = computeHashCode();
  }

  private ImmutableLogResponse(
      boolean hasMore,
      @Nullable String token,
      List<CommitMeta> operations) {
    this.hasMore = hasMore;
    this.token = token;
    this.operations = operations;
    this.hashCode = computeHashCode();
  }

  /**
   * Whether there are more result-items than returned by this response object.
   * <p>If there are more result-items, the value returned by {@link #getToken()} can be used in the
   * next invocation to get the next "page" of results.
   * @return {@code true}, if there are more result items.
   */
  @JsonProperty("hasMore")
  @Override
  public boolean hasMore() {
    return hasMore;
  }

  /**
   * Pass this value to the next invocation of the API function to get the next page of results.
   * <p>Paging tokens are opaque and the structure may change without prior notice even in patch
   * releases.
   * @return paging-token for the next invocation of an API function, if {@link #hasMore()} is
   *     {@code true}. Undefined, if {@link #hasMore()} is {@code false}.
   */
  @JsonProperty("token")
  @Override
  public @Nullable String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code operations} attribute
   */
  @JsonProperty("operations")
  @Override
  public List<CommitMeta> getOperations() {
    return operations;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LogResponse#hasMore() hasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasMore
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLogResponse withHasMore(boolean value) {
    if (this.hasMore == value) return this;
    return new ImmutableLogResponse(value, this.token, this.operations);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LogResponse#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLogResponse withToken(@Nullable String value) {
    if (Objects.equals(this.token, value)) return this;
    return new ImmutableLogResponse(this.hasMore, value, this.operations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LogResponse#getOperations() operations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLogResponse withOperations(CommitMeta... elements) {
    List<CommitMeta> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableLogResponse(this.hasMore, this.token, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LogResponse#getOperations() operations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of operations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLogResponse withOperations(Iterable<? extends CommitMeta> elements) {
    if (this.operations == elements) return this;
    List<CommitMeta> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableLogResponse(this.hasMore, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLogResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLogResponse
        && equalTo((ImmutableLogResponse) another);
  }

  private boolean equalTo(ImmutableLogResponse another) {
    if (hashCode != another.hashCode) return false;
    return hasMore == another.hasMore
        && Objects.equals(token, another.token)
        && operations.equals(another.operations);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code hasMore}, {@code token}, {@code operations}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(hasMore);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + operations.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LogResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LogResponse{"
        + "hasMore=" + hasMore
        + ", token=" + token
        + ", operations=" + operations
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "LogResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LogResponse {
    boolean hasMore;
    boolean hasMoreIsSet;
    @Nullable String token;
    @Nullable List<CommitMeta> operations = Collections.emptyList();
    @JsonProperty("hasMore")
    public void setHasMore(boolean hasMore) {
      this.hasMore = hasMore;
      this.hasMoreIsSet = true;
    }
    @JsonProperty("token")
    public void setToken(@Nullable String token) {
      this.token = token;
    }
    @JsonProperty("operations")
    public void setOperations(List<CommitMeta> operations) {
      this.operations = operations;
    }
    @Override
    public boolean hasMore() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public List<CommitMeta> getOperations() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLogResponse fromJson(Json json) {
    ImmutableLogResponse.Builder builder = ImmutableLogResponse.builder();
    if (json.hasMoreIsSet) {
      builder.hasMore(json.hasMore);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.operations != null) {
      builder.addAllOperations(json.operations);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LogResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LogResponse instance
   */
  public static ImmutableLogResponse copyOf(LogResponse instance) {
    if (instance instanceof ImmutableLogResponse) {
      return (ImmutableLogResponse) instance;
    }
    return ImmutableLogResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLogResponse ImmutableLogResponse}.
   * <pre>
   * ImmutableLogResponse.builder()
   *    .hasMore(boolean) // optional {@link LogResponse#hasMore() hasMore}
   *    .token(String | null) // nullable {@link LogResponse#getToken() token}
   *    .addOperations|addAllOperations(org.projectnessie.model.CommitMeta) // {@link LogResponse#getOperations() operations} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLogResponse builder
   */
  public static ImmutableLogResponse.Builder builder() {
    return new ImmutableLogResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLogResponse ImmutableLogResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LogResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_HAS_MORE = 0x1L;
    private long optBits;

    private boolean hasMore;
    private @Nullable String token;
    private List<CommitMeta> operations = new ArrayList<CommitMeta>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.LogResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LogResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.model.PaginatedResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PaginatedResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof LogResponse) {
        LogResponse instance = (LogResponse) object;
        addAllOperations(instance.getOperations());
      }
      if (object instanceof PaginatedResponse) {
        PaginatedResponse instance = (PaginatedResponse) object;
        hasMore(instance.hasMore());
        @Nullable String tokenValue = instance.getToken();
        if (tokenValue != null) {
          token(tokenValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link LogResponse#hasMore() hasMore} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LogResponse#hasMore() hasMore}.</em>
     * @param hasMore The value for hasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hasMore")
    public final Builder hasMore(boolean hasMore) {
      this.hasMore = hasMore;
      optBits |= OPT_BIT_HAS_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link LogResponse#getToken() token} attribute.
     * @param token The value for token (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("token")
    public final Builder token(@Nullable String token) {
      this.token = token;
      return this;
    }

    /**
     * Adds one element to {@link LogResponse#getOperations() operations} list.
     * @param element A operations element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(CommitMeta element) {
      this.operations.add(Objects.requireNonNull(element, "operations element"));
      return this;
    }

    /**
     * Adds elements to {@link LogResponse#getOperations() operations} list.
     * @param elements An array of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOperations(CommitMeta... elements) {
      for (CommitMeta element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LogResponse#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("operations")
    public final Builder operations(Iterable<? extends CommitMeta> elements) {
      this.operations.clear();
      return addAllOperations(elements);
    }

    /**
     * Adds elements to {@link LogResponse#getOperations() operations} list.
     * @param elements An iterable of operations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOperations(Iterable<? extends CommitMeta> elements) {
      for (CommitMeta element : elements) {
        this.operations.add(Objects.requireNonNull(element, "operations element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableLogResponse ImmutableLogResponse}.
     * @return An immutable instance of LogResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLogResponse build() {
      return new ImmutableLogResponse(this);
    }

    private boolean hasMoreIsSet() {
      return (optBits & OPT_BIT_HAS_MORE) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
