/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.Namespace;

public class ContentsKeySerdeTest {
    @Test
    void testNamespaceNotIncluded() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Namespace namespace = Namespace.parse((String)"a.b.c.tableName");
        Assertions.assertThat((String)namespace.name()).isEqualTo("a.b.c");
        ContentsKey key = ContentsKey.of((String[])new String[]{"a", "b", "c", "tableName"});
        Assertions.assertThat((Object)key.getNamespace()).isEqualTo((Object)namespace);
        String serializedKey = mapper.writeValueAsString((Object)key);
        ((AbstractStringAssert)Assertions.assertThat((String)serializedKey).contains(new CharSequence[]{"elements"})).doesNotContain(new CharSequence[]{"namespace"});
        ContentsKey deserialized = (ContentsKey)mapper.readValue(serializedKey, ContentsKey.class);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)key);
        Assertions.assertThat((Object)deserialized.getNamespace()).isEqualTo((Object)namespace);
    }
}

