/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import org.projectnessie.api.ConfigApi;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.ClientConfigApi;
import org.projectnessie.client.ClientContentsApi;
import org.projectnessie.client.ClientTreeApi;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.auth.AwsAuth;
import org.projectnessie.client.auth.BasicAuthFilter;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;

class NessieHttpClient
implements NessieClient {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final TreeApi tree;
    private final ConfigApi config;
    private final ContentsApi contents;

    NessieHttpClient(NessieClient.AuthType authType, URI uri, String username, String password, boolean enableTracing) {
        HttpClient client = HttpClient.builder().setBaseUri(uri).setObjectMapper(this.mapper).build();
        if (enableTracing) {
            NessieHttpClient.addTracing(client);
        }
        this.authFilter(client, authType, username, password);
        client.register(new NessieHttpResponseFilter(this.mapper));
        this.contents = this.wrap(ContentsApi.class, new ClientContentsApi(client));
        this.tree = this.wrap(TreeApi.class, new ClientTreeApi(client));
        this.config = this.wrap(ConfigApi.class, new ClientConfigApi(client));
    }

    private static void addTracing(HttpClient httpClient) {
        Tracer tracer = GlobalTracer.get();
        if (tracer != null) {
            httpClient.register(context -> {
                Span span = tracer.activeSpan();
                if (span != null) {
                    Scope scope = tracer.buildSpan("Nessie-HTTP").startActive(true);
                    context.addResponseCallback((responseContext, exception) -> {
                        if (responseContext != null) {
                            try {
                                scope.span().setTag("http.status_code", (Number)responseContext.getResponseCode().getCode());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (exception != null) {
                            HashMap<String, String> log = new HashMap<String, String>();
                            log.put("event", Tags.ERROR.getKey());
                            log.put("error.object", exception.toString());
                            Tags.ERROR.set(scope.span().log(log), Boolean.valueOf(true));
                        }
                        scope.close();
                    });
                    scope.span().setTag("http.uri", context.getUri().toString()).setTag("http.method", context.getMethod().name());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    TextMapInjectAdapter httpHeadersCarrier = new TextMapInjectAdapter(headerMap);
                    tracer.inject(scope.span().context(), Format.Builtin.HTTP_HEADERS, (Object)httpHeadersCarrier);
                    headerMap.forEach(context::putHeader);
                }
            });
        }
    }

    private void authFilter(HttpClient client, NessieClient.AuthType authType, String username, String password) {
        switch (authType) {
            case AWS: {
                client.register(new AwsAuth(this.mapper));
                break;
            }
            case BASIC: {
                client.register(new BasicAuthFilter(username, password));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot instantiate auth filter for %s. Not a valid auth type", new Object[]{authType}));
            }
        }
    }

    private <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    @Override
    public TreeApi getTreeApi() {
        return this.tree;
    }

    @Override
    public ContentsApi getContentsApi() {
        return this.contents;
    }

    @Override
    public ConfigApi getConfigApi() {
        return this.config;
    }

    @Override
    public void close() {
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException) {
                    if (targetException.getCause() instanceof NessieNotFoundException) {
                        throw targetException.getCause();
                    }
                    if (targetException.getCause() instanceof NessieConflictException) {
                        throw targetException.getCause();
                    }
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }
}

