/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.HiveDatabase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HiveDatabase", generator="Immutables")
@Immutable
public final class ImmutableHiveDatabase
implements HiveDatabase {
    private final byte[] databaseDefinition;
    private final transient int hashCode;

    private ImmutableHiveDatabase(byte[] databaseDefinition) {
        this.databaseDefinition = databaseDefinition;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="databaseDefinition")
    public byte[] getDatabaseDefinition() {
        return (byte[])this.databaseDefinition.clone();
    }

    public final ImmutableHiveDatabase withDatabaseDefinition(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableHiveDatabase(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveDatabase && this.equalTo((ImmutableHiveDatabase)another);
    }

    private boolean equalTo(ImmutableHiveDatabase another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Arrays.equals(this.databaseDefinition, another.databaseDefinition);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Arrays.hashCode(this.databaseDefinition);
        return h2;
    }

    public String toString() {
        return "HiveDatabase{databaseDefinition=" + Arrays.toString(this.databaseDefinition) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHiveDatabase fromJson(Json json) {
        Builder builder = ImmutableHiveDatabase.builder();
        if (json.databaseDefinition != null) {
            builder.databaseDefinition(json.databaseDefinition);
        }
        return builder.build();
    }

    public static ImmutableHiveDatabase copyOf(HiveDatabase instance) {
        if (instance instanceof ImmutableHiveDatabase) {
            return (ImmutableHiveDatabase)instance;
        }
        return ImmutableHiveDatabase.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HiveDatabase", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_DEFINITION = 1L;
        private long initBits = 1L;
        @Nullable
        private byte[] databaseDefinition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HiveDatabase instance) {
            Objects.requireNonNull(instance, "instance");
            this.databaseDefinition(instance.getDatabaseDefinition());
            return this;
        }

        @JsonProperty(value="databaseDefinition")
        @CanIgnoreReturnValue
        public final Builder databaseDefinition(byte ... databaseDefinition) {
            this.databaseDefinition = (byte[])databaseDefinition.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHiveDatabase build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHiveDatabase(this.databaseDefinition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseDefinition");
            }
            return "Cannot build HiveDatabase, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HiveDatabase", generator="Immutables")
    static final class Json
    implements HiveDatabase {
        @Nullable
        byte[] databaseDefinition;

        Json() {
        }

        @JsonProperty(value="databaseDefinition")
        public void setDatabaseDefinition(byte[] databaseDefinition) {
            this.databaseDefinition = databaseDefinition;
        }

        @Override
        public byte[] getDatabaseDefinition() {
            throw new UnsupportedOperationException();
        }
    }
}

