/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.perftest;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.sampler.AbstractJavaSamplerClient;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerContext;
import org.apache.jmeter.samplers.SampleResult;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.IcebergTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieSampler
extends AbstractJavaSamplerClient {
    private static final Logger logger = LoggerFactory.getLogger(NessieSampler.class);
    private static final Joiner SLASH = Joiner.on("/");
    private static final String METHOD_TAG = "method";
    private static final String URI_TAG = "uri";
    private static final String BRANCH_TAG = "branch";
    private static final String BASE_BRANCH_TAG = "base_branch";
    private static final String TABLE_TAG = "table";
    private NessieClient client;
    private String uri;
    private String branch;
    private String baseBranch;
    private ThreadLocal<Branch> commitId = new ThreadLocal();

    private synchronized NessieClient nessieClient() {
        if (this.client == null) {
            this.client = NessieClient.builder().withUri(URI.create(this.uri)).withUsername("admin_user").withPassword("test123").build();
            try {
                this.client.getTreeApi().createReference(Branch.of("main", null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.client;
    }

    public Arguments getDefaultParameters() {
        Arguments defaultParameters = new Arguments();
        defaultParameters.addArgument(METHOD_TAG, "test");
        defaultParameters.addArgument(URI_TAG, "testurl");
        defaultParameters.addArgument(BRANCH_TAG, "main");
        defaultParameters.addArgument(BASE_BRANCH_TAG, "main");
        defaultParameters.addArgument(TABLE_TAG, TABLE_TAG);
        return defaultParameters;
    }

    private void fillSampler(SampleResult sampleResult, String commitId, int retries, boolean ok, String message, int retCode, Method method) {
        sampleResult.sampleEnd();
        sampleResult.setSuccessful(ok);
        sampleResult.setResponseMessage(message);
        sampleResult.setBytes(message.getBytes().length);
        sampleResult.setResponseCode(Integer.toString(retCode));
        try {
            sampleResult.setURL(new URL(SLASH.join(this.uri, method.name(), new Object[0])));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        sampleResult.setSampleLabel(SLASH.join(this.branch, this.baseBranch, retries, commitId));
    }

    private SampleResult handle(SupplierIO<Branch> supplier, Method method) {
        int retries;
        SampleResult sampleResult = new SampleResult();
        sampleResult.sampleStart();
        try {
            Branch branch = null;
            for (retries = 0; retries < 10; ++retries) {
                try {
                    branch = supplier.get();
                    break;
                }
                catch (IOException e) {
                    this.commitId.remove();
                    continue;
                }
            }
            if (branch == null) {
                throw new UnsupportedOperationException("failed with too many retries");
            }
            String branchStr = "ok";
            this.fillSampler(sampleResult, branch.getHash(), retries, true, branchStr, 200, method);
            this.commitId.set(branch);
        }
        catch (NessieServiceException e) {
            logger.warn("Request was not successfully processed", e);
            String errStr = e.getMessage();
            this.fillSampler(sampleResult, "", retries, false, errStr, e.getError().getStatus(), method);
        }
        catch (Throwable t) {
            logger.warn("Request was not successfully processed", t);
            String msg = t.getMessage() == null ? "" : t.getMessage();
            this.fillSampler(sampleResult, "", retries, false, msg, 500, method);
        }
        return sampleResult;
    }

    public SampleResult runTest(JavaSamplerContext javaSamplerContext) {
        Method method = Method.values()[javaSamplerContext.getIntParameter(METHOD_TAG)];
        String table = javaSamplerContext.getParameter(TABLE_TAG, "y");
        switch (method) {
            case CREATE_BRANCH: {
                return this.handle(() -> {
                    this.nessieClient().getTreeApi().createReference(Branch.of(this.branch, this.baseBranch));
                    return (Branch)this.nessieClient().getTreeApi().getReferenceByName(this.branch);
                }, method);
            }
            case DELETE_BRANCH: {
                break;
            }
            case COMMIT: {
                return this.handle(() -> {
                    if (this.commitId.get() == null) {
                        Branch branch = (Branch)this.nessieClient().getTreeApi().getReferenceByName(this.branch);
                        this.commitId.set(branch);
                    }
                    this.nessieClient().getContentsApi().setContents(ContentsKey.of("name", "space", table), this.commitId.get().getName(), this.commitId.get().getHash(), "test", IcebergTable.of("path_on_disk_" + table));
                    return (Branch)this.nessieClient().getTreeApi().getReferenceByName(this.branch);
                }, method);
            }
            case MERGE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not a valid enum " + (Object)((Object)method));
            }
        }
        return null;
    }

    public void setupTest(JavaSamplerContext context) {
        this.uri = context.getParameter(URI_TAG);
        this.branch = context.getParameter(BRANCH_TAG, "x");
        this.baseBranch = context.getParameter(BASE_BRANCH_TAG, "main");
    }

    public static interface SupplierIO<T> {
        public T get() throws IOException;
    }

    static enum Method {
        CREATE_BRANCH,
        DELETE_BRANCH,
        COMMIT,
        MERGE;

    }
}

