/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.urlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.HttpStatusFamily;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.http.TlsTrustManagersProvider;
import software.amazon.awssdk.http.urlconnection.UrlConnectionFactory;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class UrlConnectionHttpClient
implements SdkHttpClient {
    private static final Logger log = Logger.loggerFor(UrlConnectionHttpClient.class);
    private static final String CLIENT_NAME = "UrlConnection";
    private final AttributeMap options;
    private final UrlConnectionFactory connectionFactory;
    private final SSLContext sslContext;

    private UrlConnectionHttpClient(AttributeMap options, UrlConnectionFactory connectionFactory) {
        this.options = options;
        if (connectionFactory != null) {
            this.sslContext = null;
            this.connectionFactory = connectionFactory;
        } else {
            this.sslContext = this.getSslContext(options);
            this.connectionFactory = this::createDefaultConnection;
        }
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public static SdkHttpClient create() {
        return new DefaultBuilder().build();
    }

    public static SdkHttpClient create(UrlConnectionFactory connectionFactory) {
        return new UrlConnectionHttpClient(AttributeMap.empty(), connectionFactory);
    }

    @Override
    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        HttpURLConnection connection = this.createAndConfigureConnection(request);
        return new RequestCallable(connection, request);
    }

    @Override
    public void close() {
    }

    @Override
    public String clientName() {
        return CLIENT_NAME;
    }

    private HttpURLConnection createAndConfigureConnection(HttpExecuteRequest request) {
        HttpURLConnection connection = this.connectionFactory.createConnection(request.httpRequest().getUri());
        request.httpRequest().headers().forEach((key, values) -> values.forEach(value -> connection.setRequestProperty((String)key, (String)value)));
        FunctionalUtils.invokeSafely(() -> connection.setRequestMethod(request.httpRequest().method().name()));
        if (request.contentStreamProvider().isPresent()) {
            connection.setDoOutput(true);
        }
        connection.setInstanceFollowRedirects(false);
        return connection;
    }

    private HttpURLConnection createDefaultConnection(URI uri) {
        HttpURLConnection connection = FunctionalUtils.invokeSafely(() -> (HttpURLConnection)uri.toURL().openConnection());
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            if (this.options.get(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES).booleanValue()) {
                httpsConnection.setHostnameVerifier(NoOpHostNameVerifier.INSTANCE);
            }
            httpsConnection.setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        connection.setConnectTimeout(NumericUtils.saturatedCast(this.options.get(SdkHttpConfigurationOption.CONNECTION_TIMEOUT).toMillis()));
        connection.setReadTimeout(NumericUtils.saturatedCast(this.options.get(SdkHttpConfigurationOption.READ_TIMEOUT).toMillis()));
        return connection;
    }

    private SSLContext getSslContext(AttributeMap options) {
        Validate.isTrue(options.get(SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) == null || options.get(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES) == false, "A TlsTrustManagerProvider can't be provided if TrustAllCertificates is also set", new Object[0]);
        TrustManager[] trustManagers = null;
        if (options.get(SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER) != null) {
            trustManagers = options.get(SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER).trustManagers();
        }
        if (options.get(SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES).booleanValue()) {
            log.warn(() -> "SSL Certificate verification is disabled. This is not a safe setting and should only be used for testing.");
            trustManagers = new TrustManager[]{TrustAllManager.INSTANCE};
        }
        TlsKeyManagersProvider provider = this.options.get(SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER);
        KeyManager[] keyManagers = provider.keyManagers();
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, null);
            return context;
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private static final TrustAllManager INSTANCE = new TrustAllManager();

        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) {
            log.debug(() -> "Accepting a client certificate: " + x509Certificates[0].getSubjectDN());
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) {
            log.debug(() -> "Accepting a server certificate: " + x509Certificates[0].getSubjectDN());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class NoOpHostNameVerifier
    implements HostnameVerifier {
        static final NoOpHostNameVerifier INSTANCE = new NoOpHostNameVerifier();

        private NoOpHostNameVerifier() {
        }

        @Override
        public boolean verify(String s2, SSLSession sslSession) {
            return true;
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();

        private DefaultBuilder() {
        }

        @Override
        public Builder socketTimeout(Duration socketTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.READ_TIMEOUT, socketTimeout);
            return this;
        }

        public void setSocketTimeout(Duration socketTimeout) {
            this.socketTimeout(socketTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration connectionTimeout) {
            this.standardOptions.put(SdkHttpConfigurationOption.CONNECTION_TIMEOUT, connectionTimeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.standardOptions.put(SdkHttpConfigurationOption.TLS_KEY_MANAGERS_PROVIDER, tlsKeyManagersProvider);
            return this;
        }

        public void setTlsKeyManagersProvider(TlsKeyManagersProvider tlsKeyManagersProvider) {
            this.tlsKeyManagersProvider(tlsKeyManagersProvider);
        }

        @Override
        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.standardOptions.put(SdkHttpConfigurationOption.TLS_TRUST_MANAGERS_PROVIDER, tlsTrustManagersProvider);
            return this;
        }

        public void setTlsTrustManagersProvider(TlsTrustManagersProvider tlsTrustManagersProvider) {
            this.tlsTrustManagersProvider(tlsTrustManagersProvider);
        }

        @Override
        public SdkHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new UrlConnectionHttpClient(this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS), null);
        }
    }

    public static interface Builder
    extends SdkHttpClient.Builder<Builder> {
        public Builder socketTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder tlsKeyManagersProvider(TlsKeyManagersProvider var1);

        public Builder tlsTrustManagersProvider(TlsTrustManagersProvider var1);
    }

    private static class RequestCallable
    implements ExecutableHttpRequest {
        private final HttpURLConnection connection;
        private final HttpExecuteRequest request;

        private RequestCallable(HttpURLConnection connection, HttpExecuteRequest request) {
            this.connection = connection;
            this.request = request;
        }

        @Override
        public HttpExecuteResponse call() throws IOException {
            this.connection.connect();
            this.request.contentStreamProvider().ifPresent(provider -> FunctionalUtils.invokeSafely(() -> IoUtils.copy(provider.newStream(), this.connection.getOutputStream())));
            int responseCode = this.connection.getResponseCode();
            boolean isErrorResponse = HttpStatusFamily.of(responseCode).isOneOf(HttpStatusFamily.CLIENT_ERROR, HttpStatusFamily.SERVER_ERROR);
            InputStream content = !isErrorResponse ? this.connection.getInputStream() : this.connection.getErrorStream();
            AbortableInputStream responseBody = content != null ? AbortableInputStream.create(content) : null;
            return HttpExecuteResponse.builder().response(SdkHttpResponse.builder().statusCode(responseCode).statusText(this.connection.getResponseMessage()).headers((Map)this.extractHeaders(this.connection)).build()).responseBody(responseBody).build();
        }

        private Map<String, List<String>> extractHeaders(HttpURLConnection response) {
            return response.getHeaderFields().entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Override
        public void abort() {
            this.connection.disconnect();
        }
    }
}

