/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class AwsAuth
implements RequestFilter {
    private final ObjectMapper objectMapper;
    private final Aws4Signer signer;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region = Region.US_WEST_2;

    public AwsAuth(ObjectMapper objectMapper) {
        this.awsCredentialsProvider = DefaultCredentialsProvider.create();
        this.signer = Aws4Signer.create();
        this.objectMapper = objectMapper;
    }

    private SdkHttpFullRequest prepareRequest(URI uri, HttpClient.Method method, Optional<Object> entity) {
        try {
            SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.fromValue(method.name()));
            Arrays.stream(uri.getQuery().split("&")).map(s2 -> s2.split("=")).forEach(s2 -> builder.putRawQueryParameter(s2[0], s2[1]));
            if (entity.isPresent()) {
                try {
                    byte[] bytes = this.objectMapper.writeValueAsBytes(entity.get());
                    builder.contentStreamProvider(() -> new ByteArrayInputStream(bytes));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return builder.build();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void filter(RequestContext context) {
        SdkHttpFullRequest modifiedRequest = this.signer.sign(this.prepareRequest(context.getUri(), context.getMethod(), context.getBody()), Aws4SignerParams.builder().signingName("execute-api").awsCredentials(this.awsCredentialsProvider.resolveCredentials()).signingRegion(this.region).build());
        for (Map.Entry<String, List<String>> entry : modifiedRequest.toBuilder().headers().entrySet()) {
            if (context.getHeaders().containsKey(entry.getKey())) continue;
            entry.getValue().forEach(a -> context.putHeader((String)entry.getKey(), (String)a));
        }
    }
}

