/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
@Immutable
final class DefaultSdkHttpFullRequest
implements SdkHttpFullRequest {
    private final String protocol;
    private final String host;
    private final Integer port;
    private final String path;
    private final Map<String, List<String>> queryParameters;
    private final SdkHttpMethod httpMethod;
    private final Map<String, List<String>> headers;
    private final ContentStreamProvider contentStreamProvider;

    private DefaultSdkHttpFullRequest(Builder builder) {
        this.protocol = this.standardizeProtocol(builder.protocol);
        this.host = Validate.paramNotNull(builder.host, "host");
        this.port = this.standardizePort(builder.port);
        this.path = this.standardizePath(builder.path);
        this.httpMethod = Validate.paramNotNull(builder.httpMethod, "method");
        this.contentStreamProvider = builder.contentStreamProvider;
        this.queryParameters = builder.queryParametersAreFromToBuilder ? builder.queryParameters : CollectionUtils.deepUnmodifiableMap(builder.queryParameters, () -> new LinkedHashMap());
        this.headers = builder.headersAreFromToBuilder ? builder.headers : CollectionUtils.deepUnmodifiableMap(builder.headers, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
    }

    private String standardizeProtocol(String protocol) {
        Validate.paramNotNull(protocol, "protocol");
        String standardizedProtocol = StringUtils.lowerCase(protocol);
        Validate.isTrue(standardizedProtocol.equals("http") || standardizedProtocol.equals("https"), "Protocol must be 'http' or 'https', but was %s", protocol);
        return standardizedProtocol;
    }

    private String standardizePath(String path) {
        if (StringUtils.isEmpty(path)) {
            return "";
        }
        StringBuilder standardizedPath = new StringBuilder();
        if (!path.startsWith("/")) {
            standardizedPath.append('/');
        }
        standardizedPath.append(path);
        return standardizedPath.toString();
    }

    private Integer standardizePort(Integer port) {
        Validate.isTrue(port == null || port >= -1, "Port must be positive (or null/-1 to indicate no port), but was '%s'", port);
        if (port != null && port == -1) {
            return null;
        }
        return port;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return Optional.ofNullable(this.port).orElseGet(() -> SdkHttpUtils.standardPort(this.protocol()));
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public String encodedPath() {
        return this.path;
    }

    @Override
    public Map<String, List<String>> rawQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public SdkHttpMethod method() {
        return this.httpMethod;
    }

    @Override
    public Optional<ContentStreamProvider> contentStreamProvider() {
        return Optional.ofNullable(this.contentStreamProvider);
    }

    @Override
    public SdkHttpFullRequest.Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return ToString.builder("DefaultSdkHttpFullRequest").add("httpMethod", (Object)this.httpMethod).add("protocol", this.protocol).add("host", this.host).add("port", this.port).add("encodedPath", this.path).add("headers", this.headers.keySet()).add("queryParameters", this.queryParameters.keySet()).build();
    }

    static final class Builder
    implements SdkHttpFullRequest.Builder {
        private String protocol;
        private String host;
        private Integer port;
        private String path;
        private boolean queryParametersAreFromToBuilder;
        private Map<String, List<String>> queryParameters;
        private SdkHttpMethod httpMethod;
        private boolean headersAreFromToBuilder;
        private Map<String, List<String>> headers;
        private ContentStreamProvider contentStreamProvider;

        Builder() {
            this.queryParameters = new LinkedHashMap<String, List<String>>();
            this.queryParametersAreFromToBuilder = false;
            this.headers = new LinkedHashMap<String, List<String>>();
            this.headersAreFromToBuilder = false;
        }

        Builder(DefaultSdkHttpFullRequest request) {
            this.queryParameters = request.queryParameters;
            this.queryParametersAreFromToBuilder = true;
            this.headers = request.headers;
            this.headersAreFromToBuilder = true;
            this.protocol = request.protocol;
            this.host = request.host;
            this.port = request.port;
            this.path = request.path;
            this.httpMethod = request.httpMethod;
            this.contentStreamProvider = request.contentStreamProvider;
        }

        @Override
        public String protocol() {
            return this.protocol;
        }

        @Override
        public SdkHttpFullRequest.Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public String host() {
            return this.host;
        }

        @Override
        public SdkHttpFullRequest.Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Integer port() {
            return this.port;
        }

        @Override
        public SdkHttpFullRequest.Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder encodedPath(String path) {
            this.path = path;
            return this;
        }

        @Override
        public String encodedPath() {
            return this.path;
        }

        @Override
        public Builder putRawQueryParameter(String paramName, List<String> paramValues) {
            this.copyQueryParamsIfNeeded();
            this.queryParameters.put(paramName, new ArrayList<String>(paramValues));
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder appendRawQueryParameter(String paramName, String paramValue) {
            this.copyQueryParamsIfNeeded();
            this.queryParameters.computeIfAbsent(paramName, k -> new ArrayList()).add(paramValue);
            return this;
        }

        @Override
        public Builder rawQueryParameters(Map<String, List<String>> queryParameters) {
            this.queryParameters = CollectionUtils.deepCopyMap(queryParameters, () -> new LinkedHashMap());
            this.queryParametersAreFromToBuilder = false;
            return this;
        }

        @Override
        public Builder removeQueryParameter(String paramName) {
            this.copyQueryParamsIfNeeded();
            this.queryParameters.remove(paramName);
            return this;
        }

        @Override
        public Builder clearQueryParameters() {
            this.queryParameters = new LinkedHashMap<String, List<String>>();
            this.queryParametersAreFromToBuilder = false;
            return this;
        }

        private void copyQueryParamsIfNeeded() {
            if (this.queryParametersAreFromToBuilder) {
                this.queryParametersAreFromToBuilder = false;
                this.queryParameters = CollectionUtils.deepCopyMap(this.queryParameters);
            }
        }

        @Override
        public Map<String, List<String>> rawQueryParameters() {
            return CollectionUtils.unmodifiableMapOfLists(this.queryParameters);
        }

        @Override
        public Builder method(SdkHttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        @Override
        public SdkHttpMethod method() {
            return this.httpMethod;
        }

        @Override
        public Builder putHeader(String headerName, List<String> headerValues) {
            this.copyHeadersIfNeeded();
            this.headers.put(headerName, new ArrayList<String>(headerValues));
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder appendHeader(String headerName, String headerValue) {
            this.copyHeadersIfNeeded();
            this.headers.computeIfAbsent(headerName, k -> new ArrayList()).add(headerValue);
            return this;
        }

        @Override
        public Builder headers(Map<String, List<String>> headers) {
            this.headers = CollectionUtils.deepCopyMap(headers);
            this.headersAreFromToBuilder = false;
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder removeHeader(String headerName) {
            this.copyHeadersIfNeeded();
            this.headers.remove(headerName);
            return this;
        }

        @Override
        public SdkHttpFullRequest.Builder clearHeaders() {
            this.headers = new LinkedHashMap<String, List<String>>();
            this.headersAreFromToBuilder = false;
            return this;
        }

        @Override
        public Map<String, List<String>> headers() {
            return CollectionUtils.unmodifiableMapOfLists(this.headers);
        }

        private void copyHeadersIfNeeded() {
            if (this.headersAreFromToBuilder) {
                this.headersAreFromToBuilder = false;
                this.headers = CollectionUtils.deepCopyMap(this.headers);
            }
        }

        @Override
        public Builder contentStreamProvider(ContentStreamProvider contentStreamProvider) {
            this.contentStreamProvider = contentStreamProvider;
            return this;
        }

        @Override
        public ContentStreamProvider contentStreamProvider() {
            return this.contentStreamProvider;
        }

        @Override
        public SdkHttpFullRequest.Builder copy() {
            return this.build().toBuilder();
        }

        @Override
        public SdkHttpFullRequest.Builder applyMutation(Consumer<SdkHttpRequest.Builder> mutator) {
            mutator.accept(this);
            return this;
        }

        @Override
        public DefaultSdkHttpFullRequest build() {
            return new DefaultSdkHttpFullRequest(this);
        }
    }
}

