/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Value;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ImmutableHiveTable;

@JsonSerialize(as=ImmutableHiveTable.class)
@JsonDeserialize(as=ImmutableHiveTable.class)
@JsonTypeName(value="HIVE_TABLE")
@Value.Immutable(prehash=true)
public abstract class HiveTable
extends Contents {
    public abstract byte[] getTableDefinition();

    public abstract List<byte[]> getPartitions();

    public int hashCode() {
        int h2 = 1;
        h2 += 31 * h2 + Objects.hashCode(this.getId());
        h2 += 31 * h2 + Arrays.hashCode(this.getTableDefinition());
        for (byte[] p : this.getPartitions()) {
            h2 += 31 * h2 + Arrays.hashCode(p);
        }
        return h2;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveTable && this.equalTo((ImmutableHiveTable)another);
    }

    private boolean equalTo(ImmutableHiveTable another) {
        if (this.hashCode() != another.hashCode()) {
            return false;
        }
        return Objects.equals(this.getId(), another.getId()) && Arrays.equals(this.getTableDefinition(), another.getTableDefinition()) && this.partitionsEqual(this.getPartitions(), another.getPartitions());
    }

    private boolean partitionsEqual(List<byte[]> partitions, List<byte[]> partitions1) {
        if (partitions.size() != partitions1.size()) {
            return false;
        }
        for (int i = 0; i < partitions.size(); ++i) {
            if (Arrays.equals(partitions.get(i), partitions1.get(i))) continue;
            return false;
        }
        return true;
    }
}

