/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.IcebergTable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IcebergTable", generator="Immutables")
@Immutable
public final class ImmutableIcebergTable
extends IcebergTable {
    private final String id;
    private final String metadataLocation;
    private final transient int hashCode;

    private ImmutableIcebergTable(Builder builder) {
        this.metadataLocation = builder.metadataLocation;
        this.id = builder.id != null ? builder.id : Objects.requireNonNull(super.getId(), "id");
        this.hashCode = this.computeHashCode();
    }

    private ImmutableIcebergTable(String id, String metadataLocation) {
        this.id = id;
        this.metadataLocation = metadataLocation;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="metadataLocation")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public final ImmutableIcebergTable withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergTable(newValue, this.metadataLocation);
    }

    public final ImmutableIcebergTable withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergTable && this.equalTo((ImmutableIcebergTable)another);
    }

    private boolean equalTo(ImmutableIcebergTable another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.id.equals(another.id) && this.metadataLocation.equals(another.metadataLocation);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + this.metadataLocation.hashCode();
        return h2;
    }

    public String toString() {
        return "IcebergTable{id=" + this.id + ", metadataLocation=" + this.metadataLocation + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIcebergTable fromJson(Json json) {
        Builder builder = ImmutableIcebergTable.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.metadataLocation != null) {
            builder.metadataLocation(json.metadataLocation);
        }
        return builder.build();
    }

    public static ImmutableIcebergTable copyOf(IcebergTable instance) {
        if (instance instanceof ImmutableIcebergTable) {
            return (ImmutableIcebergTable)instance;
        }
        return ImmutableIcebergTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String metadataLocation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Contents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IcebergTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contents instance;
            if (object instanceof Contents) {
                instance = (Contents)object;
                this.id(instance.getId());
            }
            if (object instanceof IcebergTable) {
                instance = (IcebergTable)object;
                this.metadataLocation(((IcebergTable)instance).getMetadataLocation());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            return this;
        }

        @JsonProperty(value="metadataLocation")
        @CanIgnoreReturnValue
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableIcebergTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIcebergTable(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            return "Cannot build IcebergTable, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IcebergTable", generator="Immutables")
    static final class Json
    extends IcebergTable {
        @Nullable
        String id;
        @Nullable
        String metadataLocation;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="metadataLocation")
        public void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetadataLocation() {
            throw new UnsupportedOperationException();
        }
    }
}

