/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.perftest.gatling;

import io.gatling.commons.Exclude$;
import io.gatling.commons.NotNothing$;
import io.gatling.commons.util.TypeCaster$;
import io.gatling.core.action.builder.ActionBuilder;
import io.gatling.core.protocol.Protocol;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.session.Session;
import io.gatling.core.structure.ChainBuilder;
import io.gatling.core.structure.ConditionalStatements;
import io.gatling.core.structure.Errors;
import io.gatling.core.structure.PopulationBuilder;
import io.gatling.core.structure.ScenarioBuilder;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.perftest.gatling.CommitToBranchParams;
import org.projectnessie.perftest.gatling.CommitToBranchParams$;
import org.projectnessie.perftest.gatling.NessieProtocol;
import org.projectnessie.perftest.gatling.Predef$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Int$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005q2A\u0001C\u0005\u0001%!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003BB\u0014\u0001A\u0003%A\u0005C\u0003)\u0001\u0011%\u0011\u0006C\u00031\u0001\u0011%\u0011\u0006C\u00032\u0001\u0011%!\u0007C\u00037\u0001\u0011%qG\u0001\rD_6l\u0017\u000e\u001e+p\u0005J\fgn\u00195TS6,H.\u0019;j_:T!AC\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\u0011A\"D\u0001\ta\u0016\u0014h\r^3ti*\u0011abD\u0001\u000eaJ|'.Z2u]\u0016\u001c8/[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005QaR\"A\u000b\u000b\u0005Y9\u0012\u0001C:dK:\f'/[8\u000b\u0005aI\u0012\u0001B2pe\u0016T!A\u0003\u000e\u000b\u0003m\t!![8\n\u0005u)\"AC*j[Vd\u0017\r^5p]\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011!C\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003\u0011\u0002\"!I\u0013\n\u0005\u0019J!\u0001F\"p[6LG\u000fV8Ce\u0006t7\r\u001b)be\u0006l7/A\u0004qCJ\fWn\u001d\u0011\u0002\u001d\r|W.\\5u)>\u0014%/\u00198dQV\t!\u0006\u0005\u0002,]5\tAF\u0003\u0002./\u0005I1\u000f\u001e:vGR,(/Z\u0005\u0003_1\u0012Ab\u00115bS:\u0014U/\u001b7eKJ\fAbZ3u%\u00164WM]3oG\u0016\fQBY;jY\u0012\u001c6-\u001a8be&|G#A\u001a\u0011\u0005-\"\u0014BA\u001b-\u0005=\u00196-\u001a8be&|')^5mI\u0016\u0014\u0018a\u00023p'\u0016$X\u000b\u001d\u000b\u0002qA\u0011\u0011HO\u0007\u0002\u0001%\u00111\b\b\u0002\u0006'\u0016$X\u000b\u001d")
public class CommitToBranchSimulation
extends Simulation {
    private final CommitToBranchParams params = CommitToBranchParams$.MODULE$.fromSystemProperties();

    public CommitToBranchParams params() {
        return this.params;
    }

    /*
     * WARNING - void declaration
     */
    private ChainBuilder commitToBranch() {
        ChainBuilder chainBuilder;
        ChainBuilder chain = (ChainBuilder)io.gatling.core.Predef$.MODULE$.exec((ActionBuilder)Predef$.MODULE$.nessie("Commit").execute((Function2 & Serializable)(client, session) -> {
            int commitNum = BoxesRunTime.unboxToInt((Object)session.apply("commitNum").asOption(TypeCaster$.MODULE$.IntCaster(), (ClassTag)ClassTag$.MODULE$.Int(), NotNothing$.MODULE$.notNothingEv($less$colon$less$.MODULE$.refl())).get());
            Branch branch = (Branch)session.apply("branch").as(TypeCaster$.MODULE$.genericTypeCaster(ClassTag$.MODULE$.apply(Branch.class)), ClassTag$.MODULE$.apply(Branch.class), NotNothing$.MODULE$.notNothingEv($less$colon$less$.MODULE$.refl()));
            long userId = session.userId();
            String tableName = this.params().makeTableName((Session)session);
            ContentKey key = ContentKey.of((String[])new String[]{"name", "space", tableName});
            String contentId = tableName;
            IcebergTable tableMeta = IcebergTable.of((String)new StringBuilder(14).append("path_on_disk_").append(tableName).append("_").append(commitNum).toString(), (long)42L, (int)43, (int)44, (int)45, (String)contentId);
            Operation.Put op = commitNum > 0 ? Operation.Put.of((ContentKey)key, (Content)tableMeta, (Content)IcebergTable.of((String)new StringBuilder(14).append("path_on_disk_").append(tableName).append("_").append(commitNum - 1).toString(), (long)42L, (int)43, (int)44, (int)45, (String)contentId)) : Operation.Put.of((ContentKey)key, (Content)tableMeta);
            Branch updatedBranch = ((CommitMultipleOperationsBuilder)client.commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage((String)new StringBuilder(13).append("test-commit ").append(userId).append(" ").append(commitNum).toString())).operation((Operation)op).commit();
            return session.set("branch", (Object)updatedBranch);
        }).onException((Function3 & Serializable)(e, client, session) -> {
            Session session2;
            if (e instanceof NessieConflictException) {
                Branch branch = (Branch)session.apply("branch").as(TypeCaster$.MODULE$.genericTypeCaster(ClassTag$.MODULE$.apply(Branch.class)), ClassTag$.MODULE$.apply(Branch.class), NotNothing$.MODULE$.notNothingEv($less$colon$less$.MODULE$.refl()));
                session2 = session.set("branch", (Object)((Branch)client.getReference().refName(branch.getName()).get()));
            } else {
                session2 = session;
            }
            return session2;
        }));
        if (this.params().opRate() > 0.0) {
            FiniteDuration oneHour = FiniteDuration$.MODULE$.apply(1L, TimeUnit.HOURS);
            double nanosPerIteration = (double)oneHour.toNanos() / (this.params().opRate() * (double)oneHour.toSeconds());
            chainBuilder = (ChainBuilder)((Errors)io.gatling.core.Predef$.MODULE$.pace(FiniteDuration$.MODULE$.apply((long)nanosPerIteration, TimeUnit.NANOSECONDS))).exitBlockOnFail(chain);
        } else {
            void var1_1;
            chainBuilder = var1_1;
        }
        return chainBuilder;
    }

    private ChainBuilder getReference() {
        return (ChainBuilder)((ConditionalStatements)io.gatling.core.Predef$.MODULE$.exec((ActionBuilder)Predef$.MODULE$.nessie(new StringBuilder(21).append("Create branch ").append(this.params()).append(".branch").toString()).execute((Function2 & Serializable)(client, session) -> {
            Branch branch = (Branch)client.createReference().reference((Reference)Branch.of((String)this.params().makeBranchName((Session)session), null)).create();
            return session.set("branch", (Object)branch);
        }).ignoreException().dontLog())).doIf((Function1 & Serializable)session -> io.gatling.core.Predef$.MODULE$.value2Success((Object)BoxesRunTime.boxToBoolean((!session.contains("branch") ? 1 : 0) != 0), Exclude$.MODULE$.NOT_FOR_USER_CODE()), (ChainBuilder)io.gatling.core.Predef$.MODULE$.exec((ActionBuilder)Predef$.MODULE$.nessie(new StringBuilder(21).append("Get reference ").append(this.params()).append(".branch").toString()).execute((Function2 & Serializable)(client, session) -> {
            Branch branch = (Branch)client.getReference().refName(this.params().makeBranchName((Session)session)).get();
            return session.set("branch", (Object)branch);
        }).dontLog()));
    }

    private ScenarioBuilder buildScenario() {
        ScenarioBuilder scn = (ScenarioBuilder)io.gatling.core.Predef$.MODULE$.scenario("Commit-To-Branch").exec((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ChainBuilder[]{this.getReference()}));
        return this.params().numberOfCommits() > 0 ? (ScenarioBuilder)scn.repeat(io.gatling.core.Predef$.MODULE$.value2Expression((Object)BoxesRunTime.boxToInteger((int)this.params().numberOfCommits()), Exclude$.MODULE$.NOT_FOR_USER_CODE()), "commitNum", this.commitToBranch()) : (ScenarioBuilder)scn.forever("commitNum", this.commitToBranch());
    }

    private Simulation.SetUp doSetUp() {
        NessieProtocol nessieProtocol = Predef$.MODULE$.nessie().apply().client((NessieApiV1)((HttpClientBuilder)HttpClientBuilder.builder().withUri("http://127.0.0.1:19120/api/v1")).fromSystemProperties().build(NessieApiV1.class));
        System.out.println(this.params().asPrintableString());
        Simulation.SetUp s = this.setUp((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PopulationBuilder[]{this.buildScenario().inject((Object)io.gatling.core.Predef$.MODULE$.atOnceUsers(this.params().numUsers()), (Seq)Nil$.MODULE$, io.gatling.core.Predef$.MODULE$.openInjectionProfileFactory())}));
        if (this.params().durationSeconds() > 0) {
            s = s.maxDuration(FiniteDuration$.MODULE$.apply(Int$.MODULE$.int2long(this.params().durationSeconds()), TimeUnit.SECONDS));
        }
        return s.protocols((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{nessieProtocol}));
    }

    public CommitToBranchSimulation() {
        this.doSetUp();
    }
}

