/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.Map;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.persist.adapter.GlobalLogCompactionParams;
import org.projectnessie.versioned.persist.adapter.ImmutableGlobalLogCompactionParams;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import picocli.CommandLine;

@CommandLine.Command(name="maintenance", mixinStandardHelpOptions=true, description={"Database adapter maintenance"})
public class RepoMaintenance
extends BaseCommand {
    @CommandLine.Option(names={"-L", "--no-compaction-up-to-length"}, description={"When the global-log contains only up to this number of entries, global-log compaction will not happen, defaults to 50."})
    Integer noCompactionUpToLength;
    @CommandLine.Option(names={"-W", "--no-compaction-when-compacted-within"}, description={"When the global-log contains a compacted entry within this number of entries, global-log compaction will not happen, defaults to 50."})
    Integer noCompactionWhenCompactedWithin;

    @Override
    public Integer call() {
        this.warnOnInMemory();
        ImmutableGlobalLogCompactionParams.Builder globalLogCompactionParams = GlobalLogCompactionParams.builder();
        if (this.noCompactionUpToLength != null) {
            globalLogCompactionParams.noCompactionUpToLength(this.noCompactionUpToLength.intValue());
        }
        if (this.noCompactionWhenCompactedWithin != null) {
            globalLogCompactionParams.noCompactionWhenCompactedWithin(this.noCompactionWhenCompactedWithin.intValue());
        }
        PrintWriter out = this.spec.commandLine().getOut();
        out.println("Running repository maintenance...");
        long t0 = System.nanoTime();
        Map statistics = this.databaseAdapter.repoMaintenance((RepoMaintenanceParams)RepoMaintenanceParams.builder().globalLogCompactionParams((GlobalLogCompactionParams)globalLogCompactionParams.build()).build());
        Duration duration = Duration.ofNanos(System.nanoTime() - t0);
        out.printf("Finished after %s%n", duration);
        statistics.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(top -> {
            out.printf("%nCategory '%s':%n", top.getKey());
            ((Map)top.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> String.format("    %-30s: %s", e.getKey(), e.getValue())).forEach(out::println);
        });
        return 0;
    }
}

