/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.quarkus.cli.CheckContentEntry;

@ParametersAreNonnullByDefault
@Generated(from="CheckContentEntry", generator="Immutables")
@Immutable
public final class ImmutableCheckContentEntry
implements CheckContentEntry {
    private final String status;
    private final ContentKey key;
    @Nullable
    private final Content content;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String exceptionStackTrace;

    private ImmutableCheckContentEntry(String status, ContentKey key, @Nullable Content content, @Nullable String errorMessage, @Nullable String exceptionStackTrace) {
        this.status = status;
        this.key = key;
        this.content = content;
        this.errorMessage = errorMessage;
        this.exceptionStackTrace = exceptionStackTrace;
    }

    @Override
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="exceptionStackTrace")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public final ImmutableCheckContentEntry withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckContentEntry(newValue, this.key, this.content, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableCheckContentEntry withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableCheckContentEntry(this.status, newValue, this.content, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableCheckContentEntry withContent(@Nullable Content value) {
        if (this.content == value) {
            return this;
        }
        return new ImmutableCheckContentEntry(this.status, this.key, value, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableCheckContentEntry withErrorMessage(@Nullable String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableCheckContentEntry(this.status, this.key, this.content, value, this.exceptionStackTrace);
    }

    public final ImmutableCheckContentEntry withExceptionStackTrace(@Nullable String value) {
        if (Objects.equals(this.exceptionStackTrace, value)) {
            return this;
        }
        return new ImmutableCheckContentEntry(this.status, this.key, this.content, this.errorMessage, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckContentEntry && this.equalTo(0, (ImmutableCheckContentEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckContentEntry another) {
        return this.status.equals(another.status) && this.key.equals(another.key) && Objects.equals(this.content, another.content) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.exceptionStackTrace, another.exceptionStackTrace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.exceptionStackTrace);
        return h;
    }

    public String toString() {
        return "CheckContentEntry{status=" + this.status + ", key=" + this.key + ", content=" + this.content + ", errorMessage=" + this.errorMessage + ", exceptionStackTrace=" + this.exceptionStackTrace + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheckContentEntry fromJson(Json json) {
        Builder builder = ImmutableCheckContentEntry.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.exceptionStackTrace != null) {
            builder.exceptionStackTrace(json.exceptionStackTrace);
        }
        return builder.build();
    }

    public static ImmutableCheckContentEntry copyOf(CheckContentEntry instance) {
        if (instance instanceof ImmutableCheckContentEntry) {
            return (ImmutableCheckContentEntry)instance;
        }
        return ImmutableCheckContentEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CheckContentEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STATUS = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private long initBits = 3L;
        @Nullable
        private String status;
        @Nullable
        private ContentKey key;
        @Nullable
        private Content content;
        @Nullable
        private String errorMessage;
        @Nullable
        private String exceptionStackTrace;

        private Builder() {
        }

        public final Builder from(CheckContentEntry instance) {
            String exceptionStackTraceValue;
            String errorMessageValue;
            Objects.requireNonNull(instance, "instance");
            this.status(instance.getStatus());
            this.key(instance.getKey());
            Content contentValue = instance.getContent();
            if (contentValue != null) {
                this.content(contentValue);
            }
            if ((errorMessageValue = instance.getErrorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((exceptionStackTraceValue = instance.getExceptionStackTrace()) != null) {
                this.exceptionStackTrace(exceptionStackTraceValue);
            }
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="content")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder content(@Nullable Content content) {
            this.content = content;
            return this;
        }

        @JsonProperty(value="errorMessage")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty(value="exceptionStackTrace")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder exceptionStackTrace(@Nullable String exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
            return this;
        }

        public ImmutableCheckContentEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckContentEntry(this.status, this.key, this.content, this.errorMessage, this.exceptionStackTrace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build CheckContentEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckContentEntry", generator="Immutables")
    static final class Json
    implements CheckContentEntry {
        @Nullable
        String status;
        @Nullable
        ContentKey key;
        @Nullable
        Content content;
        @Nullable
        String errorMessage;
        @Nullable
        String exceptionStackTrace;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="content")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setContent(@Nullable Content content) {
            this.content = content;
        }

        @JsonProperty(value="errorMessage")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="exceptionStackTrace")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setExceptionStackTrace(@Nullable String exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
        }

        @Override
        public String getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExceptionStackTrace() {
            throw new UnsupportedOperationException();
        }
    }
}

