/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.protobuf.ByteString;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.quarkus.cli.ImmutableCheckContentEntry;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import picocli.CommandLine;

@CommandLine.Command(name="check-content", mixinStandardHelpOptions=true, description={"Check content readability of active keys."})
public class CheckContent
extends BaseCommand {
    @CommandLine.Option(names={"-o", "--output"}, description={"JSON output file name or '-' for STDOUT. If not set, per-key status is not reported."})
    private String outputSpec;
    @CommandLine.Option(names={"-k", "--key-element"}, description={"Elements or a specific content key to check (zero or more). If not set, all current keys will be checked."})
    private List<String> keyElements;
    @CommandLine.Option(names={"-c", "--show-content"}, description={"Include content for each valid key in the output."})
    private boolean showContent;
    @CommandLine.Option(names={"-B", "--batch"}, defaultValue="25", description={"The max number of keys to load at the same time."})
    private int batchSize;
    @CommandLine.Option(names={"-W", "--worker-class"}, defaultValue="org.projectnessie.server.store.TableCommitMetaStoreWorker", description={"The class name of the Nessie Store Worker (internal)."})
    private String workerClass;
    @CommandLine.Option(names={"-r", "--ref"}, description={"Reference name to use (default branch, if not set)."})
    private String ref;
    @CommandLine.Option(names={"-H", "--hash"}, description={"Commit hash to use (defaults to the HEAD of the specified reference)."})
    private String hash;
    @CommandLine.Option(names={"-s", "--summary"}, description={"Print a summary of results to STDOUT (irrespective of the --output option)."})
    private boolean summary;
    @CommandLine.Option(names={"-E", "--error-only"}, description={"Produce JSON only for keys with errors."})
    private boolean errorOnly;
    private final AtomicInteger keysProcessed = new AtomicInteger();
    private final AtomicInteger errorDetected = new AtomicInteger();

    @Override
    public Integer call() throws Exception {
        this.warnOnInMemory();
        if (this.outputSpec != null) {
            if ("-".equals(this.outputSpec)) {
                this.check(this.spec.commandLine().getOut());
                this.spec.commandLine().getOut().println();
            } else {
                try (PrintWriter out = new PrintWriter(this.outputSpec, StandardCharsets.UTF_8);){
                    this.check(out);
                }
            }
        } else {
            this.check(new PrintWriter(OutputStream.nullOutputStream(), false, StandardCharsets.UTF_8));
        }
        if (this.summary) {
            this.spec.commandLine().getOut().printf("Detected %d errors in %d keys.%n", this.errorDetected.get(), this.keysProcessed.get());
        }
        return this.errorDetected.get() == 0 ? 0 : 2;
    }

    private void check(PrintWriter out) throws Exception {
        JsonGenerator generator = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).getFactory().createGenerator((Writer)out);
        generator.writeStartArray();
        this.check(generator);
        generator.writeEndArray();
        generator.flush();
    }

    private void check(JsonGenerator generator) throws Exception {
        StoreWorker worker = (StoreWorker)this.getClass().getClassLoader().loadClass(this.workerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Hash hash = this.hash();
        if (this.keyElements != null && !this.keyElements.isEmpty()) {
            this.check(hash, List.of(Key.of(this.keyElements)), worker, generator);
        } else {
            ArrayList<Key> batch = new ArrayList<Key>(this.batchSize);
            try (Stream keys = this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL);){
                keys.forEach(keyListEntry -> {
                    batch.add(keyListEntry.getKey());
                    if (batch.size() >= this.batchSize) {
                        this.check(hash, batch, worker, generator);
                        batch.clear();
                    }
                });
                this.check(hash, batch, worker, generator);
            }
        }
    }

    private Hash hash() throws ReferenceNotFoundException {
        if (this.hash != null) {
            return Hash.of((String)this.hash);
        }
        String effectiveRef = this.ref;
        if (effectiveRef == null) {
            effectiveRef = this.serverConfig.getDefaultBranch();
        }
        ReferenceInfo main = this.databaseAdapter.namedRef(effectiveRef, GetNamedRefsParams.DEFAULT);
        return main.getHash();
    }

    private void check(Hash hash, List<Key> keys, StoreWorker<?, ?, ?> worker, JsonGenerator generator) {
        Map values;
        try {
            values = this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL);
        }
        catch (Exception e) {
            keys.forEach(k -> this.report(generator, (Key)k, e, null));
            return;
        }
        keys.forEach(k -> {
            if (values.get(k) == null) {
                this.report(generator, (Key)k, new IllegalArgumentException("Missing content"), null);
            }
        });
        values.forEach((k, contentAndState) -> {
            try {
                Object value = worker.valueFromStore((ByteString)contentAndState.getRefState(), () -> ((ContentAndState)contentAndState).getGlobalState(), arg_0 -> ((DatabaseAdapter)this.databaseAdapter).mapToAttachment(arg_0));
                this.report(generator, (Key)k, null, value);
            }
            catch (Exception e) {
                this.report(generator, (Key)k, e, null);
            }
        });
    }

    private void report(JsonGenerator generator, Key key, Throwable error, Object content) {
        this.keysProcessed.incrementAndGet();
        if (error != null) {
            this.errorDetected.incrementAndGet();
        }
        if (error == null && this.errorOnly) {
            return;
        }
        ImmutableCheckContentEntry.Builder builder = ImmutableCheckContentEntry.builder();
        builder.key(ContentKey.of((List)key.getElements()));
        builder.status(error == null ? "OK" : "ERROR");
        if (error != null) {
            builder.errorMessage(error.getMessage());
            try (StringWriter wr = new StringWriter();
                 PrintWriter pw = new PrintWriter(wr);){
                error.printStackTrace(pw);
                pw.flush();
                builder.exceptionStackTrace(wr.toString());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        if (this.showContent && content instanceof Content) {
            builder.content((Content)content);
        }
        try {
            generator.writeObject((Object)builder.build());
            Object out = generator.getOutputTarget();
            if (out instanceof PrintWriter) {
                ((PrintWriter)out).println();
            }
            generator.flush();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

