/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import javax.inject.Inject;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import picocli.CommandLine;

@CommandLine.Command(name="erase-repository", mixinStandardHelpOptions=true, description={"Erase current Nessie repository (all data will be lost) and optionally re-initialize it."})
public class EraseRepository
extends BaseCommand {
    @CommandLine.Option(names={"-r", "--re-initialize"}, description={"Re-initialize the repository after erasure. If set, provides the default branch name for the new repository."})
    private String newDefaultBranch;
    @CommandLine.Option(names={"--confirmation-code"}, description={"Confirmation code for erasing the repository (will be emitted by this command if not set)."})
    private String confirmationCode;
    @Inject
    DatabaseAdapterConfig adapterConfig;

    @Override
    public Integer call() {
        this.warnOnInMemory();
        String code = this.getConfirmationCode();
        if (!code.equals(this.confirmationCode)) {
            this.spec.commandLine().getErr().printf("Please use the '--confirmation-code=%s' option to indicate that the repository erasure operation is intentional.%nAll Nessie data will be lost!%n", code);
            return 1;
        }
        this.databaseAdapter.eraseRepo();
        if (this.newDefaultBranch != null) {
            this.databaseAdapter.initializeRepo(this.newDefaultBranch);
        }
        return 0;
    }

    private String getConfirmationCode() {
        int code = this.adapterConfig.getRepositoryId().hashCode();
        ++code;
        code *= this.adapterConfig.getParentsPerCommit();
        code *= this.adapterConfig.getKeyListDistance();
        return Long.toString(code *= this.adapterConfig.getMaxKeyListSize(), 36);
    }
}

