/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import picocli.CommandLine;

@CommandLine.Command(name="erase-repository", mixinStandardHelpOptions=true, description={"Erase current Nessie repository (all data will be lost) and optionally re-initialize it."})
public class EraseRepository
extends BaseCommand {
    @CommandLine.Option(names={"-r", "--re-initialize"}, description={"Re-initialize the repository after erasure. If set, provides the default branch name for the new repository."})
    private String newDefaultBranch;
    @CommandLine.Option(names={"--confirmation-code"}, description={"Confirmation code for erasing the repository (will be emitted by this command if not set)."})
    private String confirmationCode;

    @Override
    protected Integer callWithDatabaseAdapter() {
        this.warnOnInMemory();
        String code = EraseRepository.getConfirmationCode(this.databaseAdapter);
        if (!code.equals(this.confirmationCode)) {
            this.spec.commandLine().getErr().printf("Please use the '--confirmation-code=%s' option to indicate that the repository erasure operation is intentional.%nAll Nessie data will be lost!%n", code);
            return 1;
        }
        this.databaseAdapter.eraseRepo();
        this.spec.commandLine().getOut().println("Repository erased.");
        if (this.newDefaultBranch != null) {
            this.databaseAdapter.initializeRepo(this.newDefaultBranch);
            this.spec.commandLine().getOut().println("Repository initialized.");
        }
        return 0;
    }

    static String getConfirmationCode(DatabaseAdapter databaseAdapter) {
        DatabaseAdapterConfig adapterConfig = databaseAdapter.getConfig();
        long code = adapterConfig.getRepositoryId().hashCode();
        ++code;
        code = 31L * code + (long)adapterConfig.getParentsPerCommit();
        code = 31L * code + (long)adapterConfig.getKeyListDistance();
        code = 31L * code + (long)adapterConfig.getMaxKeyListSize();
        return Long.toString(code, 36);
    }
}

