/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.util.concurrent.Callable;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.projectnessie.quarkus.config.VersionStoreConfig;
import org.projectnessie.services.config.ServerConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import picocli.CommandLine;

public abstract class BaseCommand
implements Callable<Integer> {
    DatabaseAdapter databaseAdapter;
    @Inject
    VersionStoreConfig versionStoreConfig;
    @Inject
    ServerConfig serverConfig;
    @Inject
    Instance<DatabaseAdapter> databaseAdapterInstance;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public final Integer call() throws Exception {
        this.databaseAdapter = (DatabaseAdapter)this.databaseAdapterInstance.get();
        return this.callWithDatabaseAdapter();
    }

    protected Integer callWithDatabaseAdapter() throws Exception {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("Command '" + this.spec.name() + "' is not (yet) supported for old Nessie storage."));
        return 1;
    }

    protected void warnOnInMemory() {
        if (this.versionStoreConfig.getVersionStoreType() == VersionStoreConfig.VersionStoreType.INMEMORY) {
            this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("****************************************************************************************\n** Repository information & maintenance for an in-memory implementation is meaningless\n****************************************************************************************\n"));
        }
    }
}

