/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.quarkus.cli.ContentInfoEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentInfoEntry", generator="Immutables")
@Immutable
public final class ImmutableContentInfoEntry
implements ContentInfoEntry {
    private final String reference;
    private final String storageModel;
    private final ContentKey key;
    private final Content.Type type;
    @Nullable
    private final String hash;
    @Nullable
    private final Long distanceFromRoot;
    @Nullable
    private final Long distanceFromHead;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String exceptionStackTrace;

    private ImmutableContentInfoEntry(String reference, String storageModel, ContentKey key, Content.Type type, @Nullable String hash, @Nullable Long distanceFromRoot, @Nullable Long distanceFromHead, @Nullable String errorMessage, @Nullable String exceptionStackTrace) {
        this.reference = reference;
        this.storageModel = storageModel;
        this.key = key;
        this.type = type;
        this.hash = hash;
        this.distanceFromRoot = distanceFromRoot;
        this.distanceFromHead = distanceFromHead;
        this.errorMessage = errorMessage;
        this.exceptionStackTrace = exceptionStackTrace;
    }

    @Override
    @JsonProperty(value="reference")
    public String getReference() {
        return this.reference;
    }

    @Override
    @JsonProperty(value="storageModel")
    public String getStorageModel() {
        return this.storageModel;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="type")
    public Content.Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="distanceFromRoot")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public Long getDistanceFromRoot() {
        return this.distanceFromRoot;
    }

    @Override
    @JsonProperty(value="distanceFromHead")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public Long getDistanceFromHead() {
        return this.distanceFromHead;
    }

    @Override
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="exceptionStackTrace")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public final ImmutableContentInfoEntry withReference(String value) {
        String newValue = Objects.requireNonNull(value, "reference");
        if (this.reference.equals(newValue)) {
            return this;
        }
        return new ImmutableContentInfoEntry(newValue, this.storageModel, this.key, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withStorageModel(String value) {
        String newValue = Objects.requireNonNull(value, "storageModel");
        if (this.storageModel.equals(newValue)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, newValue, this.key, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, newValue, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withType(Content.Type value) {
        if (this.type == value) {
            return this;
        }
        Content.Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, newValue, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, value, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withDistanceFromRoot(@Nullable Long value) {
        if (Objects.equals(this.distanceFromRoot, value)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, this.hash, value, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withDistanceFromHead(@Nullable Long value) {
        if (Objects.equals(this.distanceFromHead, value)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, this.hash, this.distanceFromRoot, value, this.errorMessage, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withErrorMessage(@Nullable String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, value, this.exceptionStackTrace);
    }

    public final ImmutableContentInfoEntry withExceptionStackTrace(@Nullable String value) {
        if (Objects.equals(this.exceptionStackTrace, value)) {
            return this;
        }
        return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentInfoEntry && this.equalTo(0, (ImmutableContentInfoEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentInfoEntry another) {
        return this.reference.equals(another.reference) && this.storageModel.equals(another.storageModel) && this.key.equals(another.key) && this.type.equals(another.type) && Objects.equals(this.hash, another.hash) && Objects.equals(this.distanceFromRoot, another.distanceFromRoot) && Objects.equals(this.distanceFromHead, another.distanceFromHead) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.exceptionStackTrace, another.exceptionStackTrace);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.storageModel.hashCode();
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.distanceFromRoot);
        h += (h << 5) + Objects.hashCode(this.distanceFromHead);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.exceptionStackTrace);
        return h;
    }

    public String toString() {
        return "ContentInfoEntry{reference=" + this.reference + ", storageModel=" + this.storageModel + ", key=" + this.key + ", type=" + this.type + ", hash=" + this.hash + ", distanceFromRoot=" + this.distanceFromRoot + ", distanceFromHead=" + this.distanceFromHead + ", errorMessage=" + this.errorMessage + ", exceptionStackTrace=" + this.exceptionStackTrace + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableContentInfoEntry fromJson(Json json) {
        Builder builder = ImmutableContentInfoEntry.builder();
        if (json.reference != null) {
            builder.reference(json.reference);
        }
        if (json.storageModel != null) {
            builder.storageModel(json.storageModel);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.distanceFromRoot != null) {
            builder.distanceFromRoot(json.distanceFromRoot);
        }
        if (json.distanceFromHead != null) {
            builder.distanceFromHead(json.distanceFromHead);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.exceptionStackTrace != null) {
            builder.exceptionStackTrace(json.exceptionStackTrace);
        }
        return builder.build();
    }

    public static ImmutableContentInfoEntry copyOf(ContentInfoEntry instance) {
        if (instance instanceof ImmutableContentInfoEntry) {
            return (ImmutableContentInfoEntry)instance;
        }
        return ImmutableContentInfoEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentInfoEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REFERENCE = 1L;
        private static final long INIT_BIT_STORAGE_MODEL = 2L;
        private static final long INIT_BIT_KEY = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        @Nullable
        private String reference;
        @Nullable
        private String storageModel;
        @Nullable
        private ContentKey key;
        @Nullable
        private Content.Type type;
        @Nullable
        private String hash;
        @Nullable
        private Long distanceFromRoot;
        @Nullable
        private Long distanceFromHead;
        @Nullable
        private String errorMessage;
        @Nullable
        private String exceptionStackTrace;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentInfoEntry instance) {
            String exceptionStackTraceValue;
            String errorMessageValue;
            Long distanceFromHeadValue;
            Long distanceFromRootValue;
            Objects.requireNonNull(instance, "instance");
            this.reference(instance.getReference());
            this.storageModel(instance.getStorageModel());
            this.key(instance.getKey());
            this.type(instance.getType());
            String hashValue = instance.getHash();
            if (hashValue != null) {
                this.hash(hashValue);
            }
            if ((distanceFromRootValue = instance.getDistanceFromRoot()) != null) {
                this.distanceFromRoot(distanceFromRootValue);
            }
            if ((distanceFromHeadValue = instance.getDistanceFromHead()) != null) {
                this.distanceFromHead(distanceFromHeadValue);
            }
            if ((errorMessageValue = instance.getErrorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((exceptionStackTraceValue = instance.getExceptionStackTrace()) != null) {
                this.exceptionStackTrace(exceptionStackTraceValue);
            }
            return this;
        }

        @JsonProperty(value="reference")
        @CanIgnoreReturnValue
        public final Builder reference(String reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="storageModel")
        @CanIgnoreReturnValue
        public final Builder storageModel(String storageModel) {
            this.storageModel = Objects.requireNonNull(storageModel, "storageModel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="key")
        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(Content.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="hash")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        @JsonProperty(value="distanceFromRoot")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder distanceFromRoot(@Nullable Long distanceFromRoot) {
            this.distanceFromRoot = distanceFromRoot;
            return this;
        }

        @JsonProperty(value="distanceFromHead")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder distanceFromHead(@Nullable Long distanceFromHead) {
            this.distanceFromHead = distanceFromHead;
            return this;
        }

        @JsonProperty(value="errorMessage")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty(value="exceptionStackTrace")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder exceptionStackTrace(@Nullable String exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
            return this;
        }

        public ImmutableContentInfoEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentInfoEntry(this.reference, this.storageModel, this.key, this.type, this.hash, this.distanceFromRoot, this.distanceFromHead, this.errorMessage, this.exceptionStackTrace);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reference");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("storageModel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ContentInfoEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContentInfoEntry", generator="Immutables")
    static final class Json
    implements ContentInfoEntry {
        @Nullable
        String reference;
        @Nullable
        String storageModel;
        @Nullable
        ContentKey key;
        @Nullable
        Content.Type type;
        @Nullable
        String hash;
        @Nullable
        Long distanceFromRoot;
        @Nullable
        Long distanceFromHead;
        @Nullable
        String errorMessage;
        @Nullable
        String exceptionStackTrace;

        Json() {
        }

        @JsonProperty(value="reference")
        public void setReference(String reference) {
            this.reference = reference;
        }

        @JsonProperty(value="storageModel")
        public void setStorageModel(String storageModel) {
            this.storageModel = storageModel;
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="type")
        public void setType(Content.Type type) {
            this.type = type;
        }

        @JsonProperty(value="hash")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="distanceFromRoot")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setDistanceFromRoot(@Nullable Long distanceFromRoot) {
            this.distanceFromRoot = distanceFromRoot;
        }

        @JsonProperty(value="distanceFromHead")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setDistanceFromHead(@Nullable Long distanceFromHead) {
            this.distanceFromHead = distanceFromHead;
        }

        @JsonProperty(value="errorMessage")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="exceptionStackTrace")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setExceptionStackTrace(@Nullable String exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
        }

        @Override
        public String getReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStorageModel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content.Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getDistanceFromRoot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getDistanceFromHead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExceptionStackTrace() {
            throw new UnsupportedOperationException();
        }
    }
}

