/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.quarkus.cli;

import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.projectnessie.quarkus.cli.BaseCommand;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.files.FileExporter;
import org.projectnessie.versioned.transfer.files.ZipArchiveExporter;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;
import picocli.CommandLine;

@CommandLine.Command(name="export", mixinStandardHelpOptions=true, description={"Exports a Nessie repository to the local file system."})
public class ExportRepository
extends BaseCommand {
    static final String PATH = "--path";
    static final String OUTPUT_FORMAT = "--output-format";
    static final String MAX_FILE_SIZE = "--max-file-size";
    static final String EXPECTED_COMMIT_COUNT = "--expected-commit-count";
    static final String OUTPUT_BUFFER_SIZE = "--output-buffer-size";
    @CommandLine.Option(names={"-p", "--path"}, required=true, paramLabel="<export-to>", description={"The ZIP file or directory to create with the export contents."})
    private Path path;
    @CommandLine.Option(names={"-F", "--output-format"}, paramLabel="<output-format>", description={"Explicitly define the output format to use to the export.", "If not specified, the implementation chooses the ZIP export, if --path ends in .zip, otherwise will use the directory output format.", "Possible values: ${COMPLETION-CANDIDATES}"})
    private Format outputFormat;
    @CommandLine.Option(names={"--max-file-size"}, description={"Maximum size of a file in bytes inside the export."})
    private Long maxFileSize;
    @CommandLine.Option(names={"-C", "--expected-commit-count"}, description={"Expected number of commits in the repository, defaults to 1000000."})
    private Integer expectedCommitCount;
    @CommandLine.Option(names={"--output-buffer-size"}, description={"Output buffer size, defaults to 32768."})
    private Integer outputBufferSize;
    @CommandLine.Option(names={"--full-scan"}, description={"Export all commits, including those that are no longer reachable any named reference.Using this option is _not_ recommended."})
    private boolean fullScan;

    @Override
    protected Integer callWithDatabaseAdapter() throws Exception {
        this.warnOnInMemory();
        try (ExportFileSupplier exportFileSupplier = this.createExportFileSupplier();){
            NessieExporter.Builder builder = NessieExporter.builder().exportFileSupplier(exportFileSupplier).databaseAdapter(this.databaseAdapter).fullScan(this.fullScan);
            if (this.maxFileSize != null) {
                builder.maxFileSize(this.maxFileSize.longValue());
            }
            if (this.expectedCommitCount != null) {
                builder.expectedCommitCount(this.expectedCommitCount.intValue());
            }
            if (this.outputBufferSize != null) {
                builder.outputBufferSize(this.outputBufferSize.intValue());
            }
            PrintWriter out = this.spec.commandLine().getOut();
            builder.progressListener((ProgressListener)new ExportProgressListener(out)).build().exportNessieRepository();
            Integer n = 0;
            return n;
        }
    }

    private ExportFileSupplier createExportFileSupplier() {
        ZipArchiveExporter exportFileSupplier;
        switch (this.exportFormat()) {
            case ZIP: {
                if (Files.isRegularFile(this.path, new LinkOption[0])) {
                    throw new CommandLine.PicocliException(String.format("Export file %s already exists, please delete it first, if you want to overwrite it.", this.path));
                }
                exportFileSupplier = ZipArchiveExporter.builder().outputFile(this.path).build();
                break;
            }
            case DIRECTORY: {
                if (Files.isRegularFile(this.path, new LinkOption[0])) {
                    throw new CommandLine.PicocliException(String.format("%s refers to a file, but export type is %s.", new Object[]{this.path, Format.DIRECTORY}));
                }
                exportFileSupplier = FileExporter.builder().targetDirectory(this.path).build();
                break;
            }
            default: {
                throw new IllegalStateException(this.exportFormat().toString());
            }
        }
        return exportFileSupplier;
    }

    private Format exportFormat() {
        if (this.outputFormat != null) {
            return this.outputFormat;
        }
        String fileName = this.path.getFileName().toString().toLowerCase(Locale.ROOT);
        return fileName.endsWith(".zip") ? Format.ZIP : Format.DIRECTORY;
    }

    private static final class ExportProgressListener
    implements ProgressListener {
        private final PrintWriter out;
        private int count;
        private boolean dot;
        private TransferTypes.ExportMeta exportMeta;

        private ExportProgressListener(PrintWriter out) {
            this.out = out;
        }

        public void progress(@Nonnull ProgressEvent progress, TransferTypes.ExportMeta meta) {
            switch (progress) {
                case FINISHED: {
                    this.out.printf("Exported Nessie repository, %d commits into %d files, %d named references into %d files.%n", this.exportMeta.getCommitCount(), this.exportMeta.getCommitsFilesCount(), this.exportMeta.getNamedReferencesCount(), this.exportMeta.getNamedReferencesFilesCount());
                    break;
                }
                case END_META: {
                    this.exportMeta = meta;
                    break;
                }
                case START_COMMITS: {
                    this.out.println("Exporting commits...");
                    this.count = 0;
                    this.dot = false;
                    break;
                }
                case END_COMMITS: {
                    if (this.dot) {
                        this.out.println();
                    }
                    this.out.printf("%d commits exported.%n%n", this.count);
                    break;
                }
                case START_NAMED_REFERENCES: {
                    this.out.println("Exporting named references...");
                    this.count = 0;
                    this.dot = false;
                    break;
                }
                case COMMIT_WRITTEN: 
                case NAMED_REFERENCE_WRITTEN: {
                    ++this.count;
                    if (this.count % 10 == 0) {
                        this.out.print('.');
                        this.dot = true;
                    }
                    if (this.count % 500 != 0) break;
                    this.out.printf(" %d%n", this.count);
                    this.dot = false;
                    break;
                }
                case END_NAMED_REFERENCES: {
                    if (this.dot) {
                        this.out.println();
                    }
                    this.out.printf("%d named references exported.%n%n", this.count);
                    break;
                }
            }
        }
    }

    static enum Format {
        ZIP,
        DIRECTORY;

    }
}

